/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.spring.batch.builder;

import com.mybatisflex.core.BaseMapper;
import com.mybatisflex.core.query.QueryWrapper;
import com.mybatisflex.spring.batch.MyBatisFlexCursorItemReader;
import java.util.Optional;

public class MyBatisFlexCursorItemReaderBuilder<T> {
    private BaseMapper<T> mapper;
    private QueryWrapper queryWrapper;
    private Boolean saveState;
    private Integer maxItemCount;

    public MyBatisFlexCursorItemReaderBuilder<T> mapper(BaseMapper<T> mapper) {
        this.mapper = mapper;
        return this;
    }

    public MyBatisFlexCursorItemReaderBuilder<T> queryWrapper(QueryWrapper queryWrapper) {
        this.queryWrapper = queryWrapper;
        return this;
    }

    public MyBatisFlexCursorItemReaderBuilder<T> saveState(boolean saveState) {
        this.saveState = saveState;
        return this;
    }

    public MyBatisFlexCursorItemReaderBuilder<T> maxItemCount(int maxItemCount) {
        this.maxItemCount = maxItemCount;
        return this;
    }

    public MyBatisFlexCursorItemReader<T> build() {
        MyBatisFlexCursorItemReader<T> reader = new MyBatisFlexCursorItemReader<T>();
        reader.setMapper(this.mapper);
        reader.setQueryWrapper(this.queryWrapper);
        Optional.ofNullable(this.saveState).ifPresent(arg_0 -> reader.setSaveState(arg_0));
        Optional.ofNullable(this.maxItemCount).ifPresent(arg_0 -> reader.setMaxItemCount(arg_0));
        return reader;
    }
}

