/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.spring.batch;

import com.mybatisflex.core.BaseMapper;
import com.mybatisflex.core.query.QueryWrapper;
import java.util.Iterator;
import java.util.Objects;
import org.apache.ibatis.cursor.Cursor;
import org.springframework.batch.item.support.AbstractItemCountingItemStreamItemReader;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class MyBatisFlexCursorItemReader<T>
extends AbstractItemCountingItemStreamItemReader<T>
implements InitializingBean {
    private BaseMapper<T> mapper;
    private QueryWrapper queryWrapper;
    private Cursor<T> cursor;
    private Iterator<T> cursorIterator;

    public MyBatisFlexCursorItemReader() {
        this.setName(ClassUtils.getShortName(MyBatisFlexCursorItemReader.class));
    }

    public void setMapper(BaseMapper<T> mapper) {
        this.mapper = mapper;
    }

    public void setQueryWrapper(QueryWrapper queryWrapper) {
        this.queryWrapper = queryWrapper;
    }

    protected T doRead() throws Exception {
        T next = null;
        if (this.cursorIterator.hasNext()) {
            next = this.cursorIterator.next();
        }
        return next;
    }

    protected void doOpen() {
        if (Objects.isNull(this.mapper) || Objects.isNull(this.queryWrapper)) {
            throw new IllegalArgumentException("mapper or queryWrapper is required.");
        }
        this.cursor = this.mapper.selectCursorByQuery(this.queryWrapper);
        this.cursorIterator = this.cursor.iterator();
    }

    protected void doClose() throws Exception {
        if (this.cursor != null) {
            this.cursor.close();
        }
        this.cursorIterator = null;
    }

    public void afterPropertiesSet() {
        Assert.notNull(this.mapper, (String)"A BaseMapper is required.");
        Assert.notNull((Object)this.queryWrapper, (String)"A queryWrapper is required.");
    }
}

