/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.mask;

import com.mybatisflex.core.mask.MaskManager;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.TypeHandler;

public class CompositeMaskTypeHandler
implements TypeHandler<Object> {
    private final String maskType;
    private final TypeHandler<Object> typeHandler;

    public CompositeMaskTypeHandler(String maskType, TypeHandler<Object> typeHandler) {
        this.maskType = maskType;
        this.typeHandler = typeHandler;
    }

    public void setParameter(PreparedStatement ps, int i, Object parameter, JdbcType jdbcType) throws SQLException {
        this.typeHandler.setParameter(ps, i, parameter, jdbcType);
    }

    public Object getResult(ResultSet rs, String columnName) throws SQLException {
        return MaskManager.mask(this.maskType, this.typeHandler.getResult(rs, columnName));
    }

    public Object getResult(ResultSet rs, int columnIndex) throws SQLException {
        return MaskManager.mask(this.maskType, this.typeHandler.getResult(rs, columnIndex));
    }

    public Object getResult(CallableStatement cs, int columnIndex) throws SQLException {
        return MaskManager.mask(this.maskType, this.typeHandler.getResult(cs, columnIndex));
    }
}

