/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.handler;

import com.mybatisflex.annotation.EnumValue;
import com.mybatisflex.core.handler.FlexEnumTypeHandler;
import com.mybatisflex.core.util.ClassUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.apache.ibatis.type.EnumTypeHandler;
import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.TypeHandler;

public class CompositeEnumTypeHandler<E extends Enum<E>>
implements TypeHandler<E> {
    private final TypeHandler<E> delegate;

    public CompositeEnumTypeHandler(Class<E> enumClass) {
        Method enumDbValueMethod;
        boolean isNotFound = false;
        List<Field> enumDbValueFields = ClassUtil.getAllFields(enumClass, f -> f.getAnnotation(EnumValue.class) != null);
        if (enumDbValueFields.isEmpty() && (enumDbValueMethod = ClassUtil.getFirstMethodByAnnotation(enumClass, EnumValue.class)) == null) {
            isNotFound = true;
        }
        this.delegate = isNotFound ? new EnumTypeHandler(enumClass) : new FlexEnumTypeHandler<E>(enumClass);
    }

    public void setParameter(PreparedStatement ps, int i, E parameter, JdbcType jdbcType) throws SQLException {
        this.delegate.setParameter(ps, i, parameter, jdbcType);
    }

    public E getResult(ResultSet rs, String columnName) throws SQLException {
        return (E)((Enum)this.delegate.getResult(rs, columnName));
    }

    public E getResult(ResultSet rs, int columnIndex) throws SQLException {
        return (E)((Enum)this.delegate.getResult(rs, columnIndex));
    }

    public E getResult(CallableStatement cs, int columnIndex) throws SQLException {
        return (E)((Enum)this.delegate.getResult(cs, columnIndex));
    }
}

