/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.datasource.processor;

import com.mybatisflex.core.datasource.processor.DataSourceProcessor;
import com.mybatisflex.core.exception.FlexAssert;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class DelegatingDataSourceProcessor
implements DataSourceProcessor {
    private final List<DataSourceProcessor> delegates;

    private DelegatingDataSourceProcessor(List<DataSourceProcessor> delegates) {
        this.delegates = delegates;
    }

    public static DelegatingDataSourceProcessor with(DataSourceProcessor ... processors) {
        FlexAssert.notEmpty(processors, "datasource processors");
        ArrayList<DataSourceProcessor> dataSourceProcessors = new ArrayList<DataSourceProcessor>(Arrays.asList(processors));
        return new DelegatingDataSourceProcessor(dataSourceProcessors);
    }

    public static DelegatingDataSourceProcessor with(List<DataSourceProcessor> processors) {
        FlexAssert.notEmpty(processors, "datasource processors");
        return new DelegatingDataSourceProcessor(processors);
    }

    @Override
    public String process(String dataSourceKey, Object mapper, Method method, Object[] arguments) {
        for (DataSourceProcessor delegate : this.delegates) {
            String returnKey = delegate.process(dataSourceKey, mapper, method, arguments);
            if (null == returnKey) continue;
            return returnKey;
        }
        return dataSourceKey;
    }
}

