/*
 * Decompiled with CFR 0.152.
 */
package com.mortennobel.imagescaling.experimental;

import com.mortennobel.imagescaling.AdvancedResizeOp;
import com.mortennobel.imagescaling.DimensionConstrain;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;

public class ImprovedMultistepRescaleOp
extends AdvancedResizeOp {
    private final Object renderingHintInterpolation;

    public ImprovedMultistepRescaleOp(int dstWidth, int dstHeight) {
        this(dstWidth, dstHeight, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
    }

    public ImprovedMultistepRescaleOp(int dstWidth, int dstHeight, Object renderingHintInterpolation) {
        this(DimensionConstrain.createAbsolutionDimension(dstWidth, dstHeight), renderingHintInterpolation);
    }

    public ImprovedMultistepRescaleOp(DimensionConstrain dimensionConstain) {
        this(dimensionConstain, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
    }

    public ImprovedMultistepRescaleOp(DimensionConstrain dimensionConstain, Object renderingHintInterpolation) {
        super(dimensionConstain);
        this.renderingHintInterpolation = renderingHintInterpolation;
        assert (RenderingHints.KEY_INTERPOLATION.isCompatibleValue(renderingHintInterpolation)) : "Rendering hint " + renderingHintInterpolation + " is not compatible with interpolation";
    }

    public BufferedImage doFilter(BufferedImage img, BufferedImage dest, int dstWidth, int dstHeight) {
        int type = img.getTransparency() == 1 ? 1 : 2;
        BufferedImage ret = img;
        int w = img.getWidth();
        int h = img.getHeight();
        do {
            if (w > dstWidth) {
                if ((w /= 2) < dstWidth) {
                    w = dstWidth;
                }
            } else {
                w = dstWidth;
            }
            if (h > dstHeight) {
                if ((h /= 2) < dstHeight) {
                    h = dstHeight;
                }
            } else {
                h = dstHeight;
            }
            BufferedImage tmp = dest != null && dest.getWidth() == w && dest.getHeight() == h && w == dstWidth && h == dstHeight ? dest : new BufferedImage(w, h, type);
            Graphics2D g2 = tmp.createGraphics();
            g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, this.renderingHintInterpolation);
            g2.drawImage(ret, 0, 0, w, h, null);
            g2.dispose();
            ret = tmp;
        } while (w != dstWidth || h != dstHeight);
        return ret;
    }
}

