/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.jdbc;

import com.mockrunner.jdbc.ResultSetFactory;
import com.mockrunner.jdbc.StringValuesTable;
import com.mockrunner.mock.jdbc.MockResultSet;

public class ArrayResultSetFactory
implements ResultSetFactory {
    private String[] columnNames = new String[0];
    private String[][] stringMatrix = new String[0][0];

    public ArrayResultSetFactory(StringValuesTable stringValuesTable) {
        if (stringValuesTable != null) {
            this.stringMatrix = stringValuesTable.getStringMatrix();
            this.columnNames = stringValuesTable.getColumnNames();
            return;
        }
        throw new IllegalArgumentException("the string table cannot be null");
    }

    public ArrayResultSetFactory(String[][] stringMatrix) {
        this.stringMatrix = StringValuesTable.verifyStringMatrix(stringMatrix);
    }

    public ArrayResultSetFactory(String[] columnNames, String[][] stringMatrix) {
        this.stringMatrix = StringValuesTable.verifyStringMatrix(stringMatrix);
        if (columnNames != null) {
            this.columnNames = StringValuesTable.verifyColumnNames(columnNames, stringMatrix);
        }
    }

    @Override
    public MockResultSet create(String id) {
        if (id != null) {
            MockResultSet resultSet = new MockResultSet(id);
            if (this.columnNames != null) {
                for (String string : this.columnNames) {
                    resultSet.addColumn(string);
                }
            }
            for (String string : this.stringMatrix) {
                resultSet.addRow((Object[])string);
            }
            return resultSet;
        }
        throw new IllegalArgumentException("the result set ID cannot be null");
    }
}

