/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.test.util;

import com.mockrunner.util.web.XmlUtil;
import java.io.FileInputStream;
import java.util.List;
import junit.framework.TestCase;
import org.jdom2.Document;
import org.jdom2.Element;

public class XmlUtilTest
extends TestCase {
    private String source;

    private void prepareHTMLFile() throws Exception {
        FileInputStream stream = new FileInputStream("target/test-classes/com/mockrunner/test/util/test.html");
        StringBuilder output = new StringBuilder();
        int nextChar = stream.read();
        while (-1 != nextChar) {
            output.append((char)nextChar);
            nextChar = stream.read();
        }
        this.source = output.toString();
    }

    private void prepareHTML() {
        String output;
        this.source = output = "<html>\n<head>\n<meta http-equiv=\"refresh\" content=\"0;URL=http://www.mockrunner.com>\"\n</head>\n<body>\n<h3>You will be redirected to <a href=\"http://www.mockrunner.com\">http://www.mockrunner.com</a></h3>\n</body>\n</html>\n";
    }

    public void testParseHTML() throws Exception {
        this.prepareHTML();
        Document document = XmlUtil.createJDOMDocument(XmlUtil.parseHTML(this.source));
        Element rootElement = document.getRootElement();
        XmlUtilTest.assertEquals((String)"html", (String)rootElement.getName());
        List children = rootElement.getChildren();
        XmlUtilTest.assertTrue((children.size() == 2 ? 1 : 0) != 0);
        Element headElement = (Element)children.get(0);
        XmlUtilTest.assertEquals((String)"head", (String)headElement.getName());
        Element metaElement = headElement.getChild("meta");
        XmlUtilTest.assertEquals((String)"refresh", (String)metaElement.getAttributeValue("http-equiv"));
        XmlUtilTest.assertEquals((String)"0;URL=http://www.mockrunner.com>", (String)metaElement.getAttributeValue("content"));
        Element bodyElement = (Element)children.get(1);
        Element h3Element = bodyElement.getChild("h3");
        XmlUtilTest.assertEquals((String)"You will be redirected to ", (String)h3Element.getText());
        Element linkElement = h3Element.getChild("a");
        XmlUtilTest.assertEquals((String)"http://www.mockrunner.com", (String)linkElement.getAttributeValue("href"));
        XmlUtilTest.assertEquals((String)"http://www.mockrunner.com", (String)linkElement.getText());
    }

    public void testParseHTMLFile() throws Exception {
        this.prepareHTMLFile();
        Document document = XmlUtil.createJDOMDocument(XmlUtil.parseHTML(this.source));
        Element rootElement = document.getRootElement();
        XmlUtilTest.assertEquals((String)"html", (String)rootElement.getName());
        List children = rootElement.getChildren();
        XmlUtilTest.assertTrue((children.size() == 2 ? 1 : 0) != 0);
        Element headElement = (Element)children.get(0);
        XmlUtilTest.assertEquals((String)"head", (String)headElement.getName());
        Element bodyElement = (Element)children.get(1);
        XmlUtilTest.assertEquals((String)"body", (String)bodyElement.getName());
        Element table = XmlUtil.getBodyFragmentFromJDOMDocument(document);
        XmlUtilTest.assertEquals((String)"table", (String)table.getName());
    }
}

