/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.gen.jar;

import com.kirkk.analyzer.framework.Jar;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class JarFileExtractor {
    private List<String> mainJars;
    private List<String> exceptionJars;

    public JarFileExtractor(List<String> mainJars, List<String> exceptionJars) {
        this.mainJars = new ArrayList<String>(mainJars);
        this.exceptionJars = new ArrayList<String>(exceptionJars);
    }

    public Jar[] filter(Jar[] jars) {
        ArrayList<Jar> finalList = new ArrayList<Jar>();
        for (Jar jar : jars) {
            if (!this.mainJars.contains(jar.getJarFileName())) continue;
            finalList.add(jar);
        }
        return finalList.toArray(new Jar[finalList.size()]);
    }

    public Map<String, Set<String>> createDependencies(Jar[] jars) {
        HashMap<String, Set<String>> finalMap = new HashMap<String, Set<String>>();
        for (Jar jar : jars) {
            if (!this.mainJars.contains(jar.getJarFileName())) continue;
            Set<String> currentSet = this.createDependencySet(jar);
            finalMap.put(jar.getJarFileName(), currentSet);
        }
        return finalMap;
    }

    private Set<String> createDependencySet(Jar jar) {
        TreeSet<String> resultSet = new TreeSet<String>();
        List dependendJars = jar.getOutgoingDependencies();
        if (null == dependendJars) {
            return resultSet;
        }
        for (Jar currentJar : dependendJars) {
            String currentJarFileName = currentJar.getJarFileName();
            resultSet.add(currentJarFileName);
            if (this.exceptionJars.contains(currentJarFileName)) continue;
            resultSet.addAll(this.createDependencySet(currentJar));
        }
        return resultSet;
    }
}

