/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.cfg;

import com.mchange.v2.cfg.MultiPropertiesConfig;
import com.mchange.v2.log.MLevel;
import com.mchange.v2.log.MLogger;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class BasicMultiPropertiesConfig
extends MultiPropertiesConfig {
    String[] rps;
    Map propsByResourcePaths = new HashMap();
    Map propsByPrefixes;
    Properties propsByKey;

    public BasicMultiPropertiesConfig(String[] resourcePaths) {
        this(resourcePaths, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public BasicMultiPropertiesConfig(String[] resourcePaths, MLogger logger) {
        ArrayList<String> goodPaths = new ArrayList<String>();
        for (String rp : resourcePaths) {
            if ("/".equals(rp)) {
                try {
                    this.propsByResourcePaths.put(rp, System.getProperties());
                    goodPaths.add(rp);
                }
                catch (SecurityException e) {
                    if (logger != null) {
                        if (!logger.isLoggable(MLevel.WARNING)) continue;
                        logger.log(MLevel.WARNING, "Read of system Properties blocked -- ignoring any configuration via System properties, and using Empty Properties! (But any configuration via a resource properties files is still okay!)", e);
                        continue;
                    }
                    System.err.println("Read of system Properties blocked -- ignoring any configuration via System properties, and using Empty Properties! (But any configuration via a resource properties files is still okay!)");
                    e.printStackTrace();
                }
                continue;
            }
            Properties p = new Properties();
            InputStream pis = MultiPropertiesConfig.class.getResourceAsStream(rp);
            if (pis != null) {
                p.load(pis);
                this.propsByResourcePaths.put(rp, p);
                goodPaths.add(rp);
                Object var11_11 = null;
                try {
                    if (pis == null) continue;
                    pis.close();
                }
                catch (IOException e2) {
                    if (logger != null) {
                        if (!logger.isLoggable(MLevel.WARNING)) continue;
                        logger.log(MLevel.WARNING, "An IOException occurred while closing InputStream from resource path '" + rp + "'.", e2);
                        continue;
                    }
                    e2.printStackTrace();
                }
                continue;
                {
                    catch (IOException e) {
                        if (logger != null) {
                            if (logger.isLoggable(MLevel.WARNING)) {
                                logger.log(MLevel.WARNING, "An IOException occurred while loading configuration properties from resource path '" + rp + "'.", e);
                            }
                        } else {
                            e.printStackTrace();
                        }
                        var11_11 = null;
                        try {
                            if (pis == null) continue;
                            pis.close();
                        }
                        catch (IOException e2) {
                            if (logger != null) {
                                if (!logger.isLoggable(MLevel.WARNING)) continue;
                                logger.log(MLevel.WARNING, "An IOException occurred while closing InputStream from resource path '" + rp + "'.", e2);
                                continue;
                            }
                            e2.printStackTrace();
                        }
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    block22: {
                        var11_11 = null;
                        try {
                            if (pis != null) {
                                pis.close();
                            }
                        }
                        catch (IOException e2) {
                            if (logger != null) {
                                if (logger.isLoggable(MLevel.WARNING)) {
                                    logger.log(MLevel.WARNING, "An IOException occurred while closing InputStream from resource path '" + rp + "'.", e2);
                                }
                                break block22;
                            }
                            e2.printStackTrace();
                        }
                    }
                    throw throwable;
                }
            }
            if (logger == null || !logger.isLoggable(MLevel.FINE)) continue;
            logger.fine("Configuration properties not found at ResourcePath '" + rp + "'. [logger name: " + logger.getName() + ']');
        }
        this.rps = goodPaths.toArray(new String[goodPaths.size()]);
        this.propsByPrefixes = Collections.unmodifiableMap(BasicMultiPropertiesConfig.extractPrefixMapFromRsrcPathMap(this.rps, this.propsByResourcePaths));
        this.propsByResourcePaths = Collections.unmodifiableMap(this.propsByResourcePaths);
        this.propsByKey = BasicMultiPropertiesConfig.extractPropsByKey(this.rps, this.propsByResourcePaths);
    }

    private static String extractPrefix(String s) {
        int lastdot = s.lastIndexOf(46);
        if (lastdot < 0) {
            return null;
        }
        return s.substring(0, lastdot);
    }

    private static Properties findProps(String rp, Map pbrp) {
        Properties p = (Properties)pbrp.get(rp);
        return p;
    }

    private static Properties extractPropsByKey(String[] resourcePaths, Map pbrp) {
        Properties out = new Properties();
        for (String rp : resourcePaths) {
            Properties p = BasicMultiPropertiesConfig.findProps(rp, pbrp);
            if (p == null) {
                System.err.println("Could not find loaded properties for resource path: " + rp);
                continue;
            }
            for (Object kObj : p.keySet()) {
                if (!(kObj instanceof String)) {
                    System.err.println(BasicMultiPropertiesConfig.class.getName() + ": " + "Properties object found at resource path " + ("/".equals(rp) ? "[system properties]" : "'" + rp + "'") + "' contains a key that is not a String: " + kObj);
                    System.err.println("Skipping...");
                    continue;
                }
                Object vObj = p.get(kObj);
                if (vObj != null && !(vObj instanceof String)) {
                    System.err.println(BasicMultiPropertiesConfig.class.getName() + ": " + "Properties object found at resource path " + ("/".equals(rp) ? "[system properties]" : "'" + rp + "'") + " contains a value that is not a String: " + vObj);
                    System.err.println("Skipping...");
                    continue;
                }
                String key = (String)kObj;
                String val = (String)vObj;
                out.put(key, val);
            }
        }
        return out;
    }

    private static Map extractPrefixMapFromRsrcPathMap(String[] resourcePaths, Map pbrp) {
        HashMap<String, Properties> out = new HashMap<String, Properties>();
        for (String rp : resourcePaths) {
            Properties p = BasicMultiPropertiesConfig.findProps(rp, pbrp);
            if (p == null) {
                System.err.println(BasicMultiPropertiesConfig.class.getName() + " -- Could not find loaded properties for resource path: " + rp);
                continue;
            }
            for (Object kObj : p.keySet()) {
                if (!(kObj instanceof String)) {
                    System.err.println(BasicMultiPropertiesConfig.class.getName() + ": " + "Properties object found at resource path " + ("/".equals(rp) ? "[system properties]" : "'" + rp + "'") + "' contains a key that is not a String: " + kObj);
                    System.err.println("Skipping...");
                    continue;
                }
                String key = (String)kObj;
                String prefix = BasicMultiPropertiesConfig.extractPrefix(key);
                while (prefix != null) {
                    Properties byPfx = (Properties)out.get(prefix);
                    if (byPfx == null) {
                        byPfx = new Properties();
                        out.put(prefix, byPfx);
                    }
                    byPfx.put(key, p.get(key));
                    prefix = BasicMultiPropertiesConfig.extractPrefix(prefix);
                }
            }
        }
        return out;
    }

    public String[] getPropertiesResourcePaths() {
        return (String[])this.rps.clone();
    }

    public Properties getPropertiesByResourcePath(String path) {
        Properties out = (Properties)this.propsByResourcePaths.get(path);
        return out == null ? new Properties() : out;
    }

    public Properties getPropertiesByPrefix(String pfx) {
        Properties out = (Properties)this.propsByPrefixes.get(pfx);
        return out == null ? new Properties() : out;
    }

    public String getProperty(String key) {
        return this.propsByKey.getProperty(key);
    }
}

