/*
 * Decompiled with CFR 0.152.
 */
package com.mayabot.nlp.segment.plugins.pos;

import com.mayabot.nlp.common.FastStringBuilder;
import com.mayabot.nlp.hppc.IntArrayList;
import com.mayabot.nlp.perceptron.DATFeatureSetBuilder;
import com.mayabot.nlp.perceptron.FeatureSet;
import com.mayabot.nlp.perceptron.Perceptron;
import com.mayabot.nlp.perceptron.PerceptronTrainer;
import com.mayabot.nlp.perceptron.TrainSample;
import com.mayabot.nlp.segment.Nature;
import com.mayabot.nlp.segment.common.PerceptronUtilsKt;
import com.mayabot.nlp.segment.common.PkuWord;
import com.mayabot.nlp.segment.plugins.pos.POSEvaluateRunner;
import com.mayabot.nlp.segment.plugins.pos.POSPerceptron;
import com.mayabot.nlp.segment.plugins.pos.POSPerceptronFeature;
import com.mayabot.nlp.utils.CharNormUtils;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KDeclarationContainer;
import kotlin.sequences.Sequence;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u0010J\u0016\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00130\u0010H\u0002J&\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\fR\u001a\u0010\u0003\u001a\u00020\u0004X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001d\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001d"}, d2={"Lcom/mayabot/nlp/segment/plugins/pos/POSPerceptronTrainer;", "", "()V", "featureSet", "Lcom/mayabot/nlp/perceptron/FeatureSet;", "getFeatureSet", "()Lcom/mayabot/nlp/perceptron/FeatureSet;", "setFeatureSet", "(Lcom/mayabot/nlp/perceptron/FeatureSet;)V", "labelMap", "", "", "", "getLabelMap", "()Ljava/util/Map;", "loadSamples", "", "Lcom/mayabot/nlp/perceptron/TrainSample;", "files", "Ljava/io/File;", "prepareFeatureSet", "", "corposFiles", "train", "Lcom/mayabot/nlp/segment/plugins/pos/POSPerceptron;", "trainFile", "evaluate", "maxIter", "threadNumber", "mynlp-segment"})
public final class POSPerceptronTrainer {
    @NotNull
    public FeatureSet featureSet;
    @NotNull
    private final Map<String, Integer> labelMap;

    @NotNull
    public final FeatureSet getFeatureSet() {
        FeatureSet featureSet = this.featureSet;
        if (featureSet == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"featureSet");
        }
        return featureSet;
    }

    public final void setFeatureSet(@NotNull FeatureSet featureSet) {
        Intrinsics.checkParameterIsNotNull((Object)featureSet, (String)"<set-?>");
        this.featureSet = featureSet;
    }

    @NotNull
    public final Map<String, Integer> getLabelMap() {
        return this.labelMap;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final POSPerceptron train(@NotNull File trainFile, @NotNull File evaluate2, int maxIter, int threadNumber) {
        String[] stringArray;
        void $this$toTypedArray$iv;
        Intrinsics.checkParameterIsNotNull((Object)trainFile, (String)"trainFile");
        Intrinsics.checkParameterIsNotNull((Object)evaluate2, (String)"evaluate");
        List<File> allFiles2 = PerceptronUtilsKt.allFiles(trainFile);
        this.prepareFeatureSet(allFiles2);
        StringBuilder stringBuilder = new StringBuilder().append("Feature Set Size ");
        FeatureSet featureSet = this.featureSet;
        if (featureSet == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"featureSet");
        }
        String string = stringBuilder.append(featureSet.size()).toString();
        boolean bl = false;
        System.out.println((Object)string);
        List<TrainSample> sampleList = this.loadSamples(allFiles2);
        List<TrainSample> evaluateSampleList = Intrinsics.areEqual((Object)evaluate2, (Object)trainFile) ? sampleList : this.loadSamples(PerceptronUtilsKt.allFiles(evaluate2));
        String string2 = "Start Train ... ";
        boolean bl2 = false;
        System.out.println((Object)string2);
        FeatureSet featureSet2 = this.featureSet;
        if (featureSet2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"featureSet");
        }
        PerceptronTrainer trainer2 = new PerceptronTrainer(featureSet2, this.labelMap.size(), sampleList, (Function2)new Function2<Integer, Perceptron, Unit>(new POSEvaluateRunner(evaluateSampleList)){

            public final void invoke(int p1, @NotNull Perceptron p2) {
                Intrinsics.checkParameterIsNotNull((Object)p2, (String)"p2");
                ((POSEvaluateRunner)this.receiver).run(p1, p2);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(POSEvaluateRunner.class);
            }

            public final String getName() {
                return "run";
            }

            public final String getSignature() {
                return "run(ILcom/mayabot/nlp/perceptron/Perceptron;)V";
            }
        }, maxIter, true);
        Perceptron model = trainer2.train(threadNumber);
        Object object = "--------------------";
        boolean bl3 = false;
        System.out.println(object);
        new POSEvaluateRunner(evaluateSampleList).run(0, model);
        object = CollectionsKt.sorted((Iterable)this.labelMap.keySet());
        Perceptron perceptron = model;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray2 = thisCollection$iv.toArray(new String[0]);
        if (stringArray2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        String[] stringArray3 = stringArray = stringArray2;
        Perceptron perceptron2 = perceptron;
        return new POSPerceptron(perceptron2, stringArray3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final List<TrainSample> loadSamples(@NotNull List<? extends File> files) {
        Object object;
        boolean bl;
        Object object2;
        Intrinsics.checkParameterIsNotNull(files, (String)"files");
        Function1<List<? extends PkuWord>, TrainSample> $fun$sentenceToSample$1 = new Function1<List<? extends PkuWord>, TrainSample>(this){
            final /* synthetic */ POSPerceptronTrainer this$0;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final TrainSample invoke(@NotNull List<PkuWord> line) {
                void $this$mapTo$iv$iv;
                Object object;
                Collection collection;
                void $this$mapTo$iv$iv2;
                Intrinsics.checkParameterIsNotNull(line, (String)"line");
                FastStringBuilder buffer = new FastStringBuilder(100);
                Iterable $this$map$iv = line;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Iterable<E> destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv2) {
                    void it;
                    PkuWord pkuWord = (PkuWord)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    object = it.getWord();
                    collection.add(object);
                }
                List words = (List)destination$iv$iv;
                Iterable $this$map$iv2 = line;
                int $i$f$map2 = 0;
                destination$iv$iv = $this$map$iv2;
                Collection destination$iv$iv2 = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                boolean $i$f$mapTo2 = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    PkuWord bl = (PkuWord)item$iv$iv;
                    collection = destination$iv$iv2;
                    boolean bl2 = false;
                    Integer n = this.this$0.getLabelMap().get(it.getPos());
                    if (n == null) {
                        Intrinsics.throwNpe();
                    }
                    object = ((Number)n).intValue();
                    collection.add(object);
                }
                int[] poss = CollectionsKt.toIntArray((Collection)((List)destination$iv$iv2));
                ArrayList<E> featureMatrix = new ArrayList<E>(words.size());
                $i$f$map2 = 0;
                int n = words.size();
                while ($i$f$map2 < n) {
                    void i;
                    Collection collection2 = featureMatrix;
                    IntArrayList intArrayList = POSPerceptronFeature.extractFeatureVector(words, words.size(), (int)i, this.this$0.getFeatureSet(), buffer);
                    boolean bl = false;
                    collection2.add(intArrayList);
                    ++i;
                }
                return new TrainSample((List)featureMatrix, poss);
            }
            {
                this.this$0 = pOSPerceptronTrainer;
                super(1);
            }
        };
        int sampleSize = 0;
        Object $this$forEach$iv = files;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv = iterator.next();
            File file = (File)element$iv;
            boolean bl2 = false;
            File $this$useLines$iv = file;
            Charset charset$iv = Charsets.UTF_8;
            boolean $i$f$useLines = false;
            Object object3 = $this$useLines$iv;
            int n = 8192;
            boolean bl3 = false;
            Object object4 = object3;
            boolean bl4 = false;
            object2 = object4;
            bl = false;
            object2 = new FileInputStream((File)object2);
            bl = false;
            object4 = new InputStreamReader((InputStream)object2, charset$iv);
            bl4 = false;
            object3 = object4 instanceof BufferedReader ? (BufferedReader)object4 : new BufferedReader((Reader)object4, n);
            n = 0;
            object = null;
            try {
                BufferedReader it$iv = (BufferedReader)object3;
                boolean bl5 = false;
                Sequence it = TextStreamsKt.lineSequence((BufferedReader)it$iv);
                boolean bl6 = false;
                Sequence $this$forEach$iv2 = it;
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    String line = (String)element$iv2;
                    boolean bl7 = false;
                    CharSequence charSequence = line;
                    boolean bl8 = false;
                    if (!(!StringsKt.isBlank((CharSequence)charSequence))) continue;
                    int n2 = sampleSize;
                    sampleSize = n2 + 1;
                }
                object4 = Unit.INSTANCE;
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object3, (Throwable)object);
            }
        }
        $this$forEach$iv = "Will load " + sampleSize + " Sample";
        $i$f$forEach = false;
        System.out.println($this$forEach$iv);
        ArrayList sampleList = new ArrayList(sampleSize + 10);
        int count = 0;
        System.out.print("Load 0%");
        Iterable $this$forEach$iv3 = files;
        boolean $i$f$forEach3 = false;
        for (Object element$iv : $this$forEach$iv3) {
            File file = (File)element$iv;
            boolean bl9 = false;
            File $this$useLines$iv = file;
            Charset charset$iv = Charsets.UTF_8;
            boolean $i$f$useLines = false;
            object = $this$useLines$iv;
            int n = 8192;
            boolean bl10 = false;
            object2 = object;
            bl = false;
            Object object5 = object2;
            boolean bl11 = false;
            object5 = new FileInputStream((File)object5);
            bl11 = false;
            object2 = new InputStreamReader((InputStream)object5, charset$iv);
            bl = false;
            object = object2 instanceof BufferedReader ? (BufferedReader)object2 : new BufferedReader((Reader)object2, n);
            n = 0;
            Throwable throwable = null;
            try {
                BufferedReader it$iv = (BufferedReader)object;
                boolean bl12 = false;
                Sequence lines = TextStreamsKt.lineSequence((BufferedReader)it$iv);
                boolean bl13 = false;
                Sequence $this$forEach$iv4 = lines;
                boolean $i$f$forEach4 = false;
                for (Object element$iv3 : $this$forEach$iv4) {
                    String string;
                    void $this$filterTo$iv$iv;
                    String line = (String)element$iv3;
                    boolean bl14 = false;
                    Iterable $this$filter$iv = PerceptronUtilsKt.parseToFlatWords(line);
                    boolean $i$f$filter = false;
                    Iterable iterable = $this$filter$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$filterTo = false;
                    for (Object element$iv$iv : $this$filterTo$iv$iv) {
                        PkuWord it = (PkuWord)element$iv$iv;
                        boolean bl15 = false;
                        CharSequence charSequence = it.getWord();
                        boolean bl16 = false;
                        if (!(charSequence.length() > 0 && Intrinsics.areEqual((Object)it.getPos(), (Object)"") ^ true)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    List words = (List)destination$iv$iv;
                    Iterable $this$forEach$iv5 = words;
                    boolean $i$f$forEach5 = false;
                    for (Object element$iv4 : $this$forEach$iv5) {
                        PkuWord it = (PkuWord)element$iv4;
                        boolean bl17 = false;
                        String string2 = CharNormUtils.convert((String)it.getWord());
                        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"CharNormUtils.convert(it.word)");
                        it.setWord(string2);
                    }
                    Collection collection = sampleList;
                    Object[] objectArray = $fun$sentenceToSample$1.invoke((List<PkuWord>)words);
                    boolean bl18 = false;
                    collection.add(objectArray);
                    int n3 = count;
                    if ((count = n3 + 1) % 100 != 0) continue;
                    String string3 = "%.2f";
                    objectArray = new Object[]{(double)count * 100.0 / (double)sampleList.size()};
                    StringBuilder stringBuilder = new StringBuilder().append("\rLoad ");
                    PrintStream printStream = System.out;
                    bl18 = false;
                    Intrinsics.checkExpressionValueIsNotNull((Object)String.format(string3, Arrays.copyOf(objectArray, objectArray.length)), (String)"java.lang.String.format(this, *args)");
                    printStream.print(stringBuilder.append(string).append('%').toString());
                }
                object2 = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
        }
        System.out.print("\r");
        return sampleList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void prepareFeatureSet(List<? extends File> corposFiles) {
        String string = "\u5f00\u59cb\u6784\u5efaPOS FeatureSet";
        boolean bl = false;
        System.out.println((Object)string);
        long t1 = System.currentTimeMillis();
        DATFeatureSetBuilder builder = new DATFeatureSetBuilder(this.labelMap.size());
        Consumer fit2 = new Consumer<String>(builder){
            final /* synthetic */ DATFeatureSetBuilder $builder;

            public final void accept(@NotNull String f) {
                Intrinsics.checkParameterIsNotNull((Object)f, (String)"f");
                this.$builder.put(f);
            }
            {
                this.$builder = dATFeatureSetBuilder;
            }
        };
        Iterable $this$forEach$iv = corposFiles;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File file = (File)element$iv;
            boolean bl2 = false;
            String string2 = file.getAbsolutePath();
            boolean bl3 = false;
            System.out.println((Object)string2);
            File $this$useLines$iv = file;
            Charset charset$iv = Charsets.UTF_8;
            boolean $i$f$useLines = false;
            Object object = $this$useLines$iv;
            int n = 8192;
            boolean bl4 = false;
            Object object2 = object;
            boolean bl5 = false;
            Object object3 = object2;
            boolean bl6 = false;
            object3 = new FileInputStream((File)object3);
            bl6 = false;
            object2 = new InputStreamReader((InputStream)object3, charset$iv);
            bl5 = false;
            object = object2 instanceof BufferedReader ? (BufferedReader)object2 : new BufferedReader((Reader)object2, n);
            n = 0;
            Throwable throwable = null;
            try {
                BufferedReader it$iv = (BufferedReader)object;
                boolean bl7 = false;
                Sequence lines = TextStreamsKt.lineSequence((BufferedReader)it$iv);
                boolean bl8 = false;
                Sequence $this$forEach$iv2 = lines;
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    void $this$filterTo$iv$iv;
                    String it;
                    Iterable $this$mapTo$iv$iv;
                    String line = (String)element$iv2;
                    boolean bl9 = false;
                    List<PkuWord> flatWords = PerceptronUtilsKt.parseToFlatWords(line);
                    Iterable $this$map$iv = flatWords;
                    boolean $i$f$map = false;
                    Iterable iterable = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        PkuWord pkuWord = (PkuWord)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl10 = false;
                        String string3 = CharNormUtils.convert((String)((PkuWord)((Object)it)).getWord());
                        collection.add(string3);
                    }
                    Iterable $this$filter$iv22 = (List)destination$iv$iv;
                    boolean $i$f$filter = false;
                    $this$mapTo$iv$iv = $this$filter$iv22;
                    destination$iv$iv = new ArrayList();
                    boolean $i$f$filterTo = false;
                    for (Object element$iv$iv : $this$filterTo$iv$iv) {
                        it = (String)element$iv$iv;
                        boolean bl11 = false;
                        String string4 = it;
                        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"it");
                        CharSequence charSequence = string4;
                        boolean bl12 = false;
                        if (!(charSequence.length() > 0)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    List words = (List)destination$iv$iv;
                    int $this$filter$iv22 = 0;
                    int n2 = words.size();
                    while ($this$filter$iv22 < n2) {
                        void i;
                        POSPerceptronFeature.extractFeature(words, words.size(), (int)i, fit2);
                        ++i;
                    }
                }
                object2 = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
        }
        String string5 = "Start build featureSet ...";
        boolean bl13 = false;
        System.out.println((Object)string5);
        this.featureSet = builder.build();
        string5 = "FeatureSet\u6784\u5efa\u5b8c\u6210,\u7528\u65f6" + (System.currentTimeMillis() - t1) + "ms";
        bl13 = false;
        System.out.println((Object)string5);
    }

    /*
     * WARNING - void declaration
     */
    public POSPerceptronTrainer() {
        void $this$mapTo$iv$iv;
        Iterable $this$filterTo$iv$iv;
        Nature[] $this$filter$iv = Nature.values();
        boolean $i$f$filter = false;
        Nature[] natureArray = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv;
        int n = ((void)iterator).length;
        for (int i = 0; i < n; ++i) {
            void element$iv$iv;
            void it = element$iv$iv = iterator[i];
            boolean bl = false;
            if (!(it != Nature.newWord && it != Nature.begin && it != Nature.end)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Nature nature = (Nature)((Object)item$iv$iv);
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = it.name();
            collection.add(string);
        }
        List list = CollectionsKt.sorted((Iterable)((List)destination$iv$iv));
        HashMap map = new HashMap(Nature.values().length * 3);
        Iterable $this$forEach$iv = CollectionsKt.zip((Iterable)list, (Iterable)((Iterable)RangesKt.until((int)0, (int)list.size())));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair x = (Pair)element$iv;
            boolean bl = false;
            ((Map)map).put(x.getFirst(), x.getSecond());
        }
        this.labelMap = map;
    }
}

