/*
 * Decompiled with CFR 0.152.
 */
package com.mayabot.nlp.segment.plugins.pos;

import com.mayabot.nlp.common.FastStringBuilder;
import com.mayabot.nlp.hppc.IntArrayList;
import com.mayabot.nlp.perceptron.FeatureSet;
import com.mayabot.nlp.perceptron.Perceptron;
import com.mayabot.nlp.perceptron.PerceptronModel;
import com.mayabot.nlp.segment.Nature;
import com.mayabot.nlp.segment.plugins.pos.POSPerceptronFeature;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.DoubleCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000  2\u00020\u0001:\u0001 B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0006J4\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00100\u0017\"\u0004\b\u0000\u0010\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u0002H\u00180\u00172\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u0002H\u0018\u0012\u0004\u0012\u00020\u00060\u001bJ\u001a\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00100\u00172\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00060\u0017J\u000e\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fR\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\n\n\u0002\u0010\f\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR!\u0010\u000f\u001a\u0010\u0012\f\u0012\n \u0011*\u0004\u0018\u00010\u00100\u00100\u0005\u00a2\u0006\n\n\u0002\u0010\u0014\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006!"}, d2={"Lcom/mayabot/nlp/segment/plugins/pos/POSPerceptron;", "", "model", "Lcom/mayabot/nlp/perceptron/Perceptron;", "labelList", "", "", "(Lcom/mayabot/nlp/perceptron/Perceptron;[Ljava/lang/String;)V", "featureSet", "Lcom/mayabot/nlp/perceptron/FeatureSet;", "getLabelList", "()[Ljava/lang/String;", "[Ljava/lang/String;", "getModel", "()Lcom/mayabot/nlp/perceptron/Perceptron;", "natureList", "Lcom/mayabot/nlp/segment/Nature;", "kotlin.jvm.PlatformType", "getNatureList", "()[Lcom/mayabot/nlp/segment/Nature;", "[Lcom/mayabot/nlp/segment/Nature;", "decode", "word", "", "T", "sentence", "sink", "Ljava/util/function/Function;", "save", "", "dir", "Ljava/io/File;", "Companion", "mynlp-segment"})
public final class POSPerceptron {
    private final FeatureSet featureSet;
    @NotNull
    private final Nature[] natureList;
    @NotNull
    private final Perceptron model;
    @NotNull
    private final String[] labelList;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final Nature[] getNatureList() {
        return this.natureList;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Nature> decode(@NotNull List<String> sentence) {
        void $this$mapTo$iv$iv;
        int[] result;
        Object object;
        Intrinsics.checkParameterIsNotNull(sentence, (String)"sentence");
        FastStringBuilder buffer = new FastStringBuilder(100);
        int size = sentence.size();
        ArrayList featureList = new ArrayList(size);
        int n = 0;
        int n2 = size;
        while (n < n2) {
            void i;
            Collection collection = featureList;
            object = POSPerceptronFeature.extractFeatureVector(sentence, size, (int)i, this.featureSet, buffer);
            boolean bl = false;
            collection.add(object);
            ++i;
        }
        int[] $this$map$iv = result = this.model.decode((List)featureList);
        boolean $i$f$map = false;
        object = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        void var11_15 = $this$mapTo$iv$iv;
        int n3 = ((void)var11_15).length;
        for (int i = 0; i < n3; ++i) {
            void it;
            void item$iv$iv;
            void var15_19 = item$iv$iv = var11_15[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Nature nature = this.natureList[it];
            collection.add(nature);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final <T> List<Nature> decode(@NotNull List<? extends T> sentence, @NotNull Function<T, String> sink) {
        void $this$mapTo$iv$iv;
        int[] result;
        Object object;
        Intrinsics.checkParameterIsNotNull(sentence, (String)"sentence");
        Intrinsics.checkParameterIsNotNull(sink, (String)"sink");
        int size = sentence.size();
        FastStringBuilder buffer = new FastStringBuilder(100);
        ArrayList featureList = new ArrayList(size);
        int n = 0;
        int n2 = size;
        while (n < n2) {
            void i;
            Collection collection = featureList;
            object = POSPerceptronFeature.extractFeatureVector2(sentence, size, (int)i, this.featureSet, sink, buffer);
            boolean bl = false;
            collection.add(object);
            ++i;
        }
        int[] $this$map$iv = result = this.model.decode((List)featureList);
        boolean $i$f$map = false;
        object = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        void var12_16 = $this$mapTo$iv$iv;
        int n3 = ((void)var12_16).length;
        for (int i = 0; i < n3; ++i) {
            void it;
            void item$iv$iv;
            void var16_20 = item$iv$iv = var12_16[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Nature nature = this.natureList[it];
            collection.add(nature);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Nature decode(@NotNull String word) {
        int j;
        Intrinsics.checkParameterIsNotNull((Object)word, (String)"word");
        int labelSize = this.labelList.length;
        FastStringBuilder buffer = new FastStringBuilder(50);
        IntArrayList vector = POSPerceptronFeature.extractFeatureVector(CollectionsKt.listOf((Object)word), 1, 0, this.featureSet, buffer);
        int[] vectorBuffer = vector.buffer;
        int maxIndex = 0;
        double maxScore = DoubleCompanionObject.INSTANCE.getMIN_VALUE();
        int[] offset = new int[vector.size() - 1];
        int n = 0;
        int n2 = vector.size() - 1;
        while (n < n2) {
            int index = vectorBuffer[j];
            offset[j] = index * labelSize;
            ++j;
        }
        j = 0;
        n2 = labelSize;
        while (j < n2) {
            void label;
            double score = 0.0;
            int n3 = 0;
            int n4 = vector.size() - 1;
            while (n3 < n4) {
                void j2;
                score += (double)this.model.parameterAt(offset[j2] + label);
                ++j2;
            }
            if (score > maxScore) {
                maxIndex = label;
                maxScore = score;
            }
            ++label;
        }
        Nature nature = this.natureList[maxIndex];
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)nature), (String)"natureList[maxIndex]");
        return nature;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void save(@NotNull File dir) {
        Intrinsics.checkParameterIsNotNull((Object)dir, (String)"dir");
        dir.mkdirs();
        this.model.save(dir);
        Object object = new File(dir, "label.txt");
        Charset charset = Charsets.UTF_8;
        int n = 8192;
        boolean bl = false;
        Object object2 = object;
        boolean bl2 = false;
        Object object3 = object2;
        boolean bl3 = false;
        object3 = new FileOutputStream((File)object3);
        bl3 = false;
        object2 = new OutputStreamWriter((OutputStream)object3, charset);
        bl2 = false;
        BufferedWriter out = object2 instanceof BufferedWriter ? (BufferedWriter)object2 : new BufferedWriter((Writer)object2, n);
        object = out;
        boolean bl4 = false;
        Throwable throwable = null;
        try {
            BufferedWriter it = (BufferedWriter)object;
            boolean bl5 = false;
            it.write(ArraysKt.joinToString$default((Object[])this.labelList, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null));
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
    }

    @NotNull
    public final Perceptron getModel() {
        return this.model;
    }

    @NotNull
    public final String[] getLabelList() {
        return this.labelList;
    }

    /*
     * WARNING - void declaration
     */
    public POSPerceptron(@NotNull Perceptron model, @NotNull String[] labelList) {
        void $this$toTypedArray$iv;
        Collection<Nature> collection;
        void $this$mapTo$iv$iv;
        Collection $this$map$iv;
        Intrinsics.checkParameterIsNotNull((Object)model, (String)"model");
        Intrinsics.checkParameterIsNotNull((Object)labelList, (String)"labelList");
        this.model = model;
        this.labelList = labelList;
        this.featureSet = this.model.featureSet();
        String[] stringArray = this.labelList;
        POSPerceptron pOSPerceptron = this;
        boolean $i$f$map = false;
        void var5_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
        boolean $i$f$mapTo = false;
        void var8_9 = $this$mapTo$iv$iv;
        int n = ((void)var8_9).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var12_13 = item$iv$iv = var8_9[i];
            collection = destination$iv$iv;
            boolean bl = false;
            Nature nature = Nature.parse((String)it);
            collection.add(nature);
        }
        collection = (List)destination$iv$iv;
        $this$map$iv = collection;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        Nature[] natureArray = thisCollection$iv.toArray(new Nature[0]);
        if (natureArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        collection = natureArray;
        pOSPerceptron.natureList = (Nature[])collection;
    }

    @JvmStatic
    @NotNull
    public static final POSPerceptron load(@NotNull File dir) {
        return Companion.load(dir);
    }

    @JvmStatic
    @NotNull
    public static final POSPerceptron load(@NotNull InputStream parameterBin, @NotNull InputStream featureBin, @NotNull InputStream labelText) {
        return Companion.load(parameterBin, featureBin, labelText);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\bH\u0007\u00a8\u0006\u000b"}, d2={"Lcom/mayabot/nlp/segment/plugins/pos/POSPerceptron$Companion;", "", "()V", "load", "Lcom/mayabot/nlp/segment/plugins/pos/POSPerceptron;", "dir", "Ljava/io/File;", "parameterBin", "Ljava/io/InputStream;", "featureBin", "labelText", "mynlp-segment"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final POSPerceptron load(@NotNull File dir) {
            Intrinsics.checkParameterIsNotNull((Object)dir, (String)"dir");
            Object object = new File(dir, "parameter.bin");
            int n = 0;
            object = new FileInputStream((File)object);
            n = 8192;
            int n2 = 0;
            BufferedInputStream parameterBin = object instanceof BufferedInputStream ? (BufferedInputStream)object : new BufferedInputStream((InputStream)object, n);
            Object object2 = new File(dir, "feature.dat");
            n2 = 0;
            object2 = new FileInputStream((File)object2);
            n2 = 8192;
            int n3 = 0;
            BufferedInputStream featureBin = object2 instanceof BufferedInputStream ? (BufferedInputStream)object2 : new BufferedInputStream((InputStream)object2, n2);
            Object object3 = new File(dir, "label.txt");
            n3 = 0;
            object3 = new FileInputStream((File)object3);
            n3 = 8192;
            boolean bl = false;
            BufferedInputStream labelText = object3 instanceof BufferedInputStream ? (BufferedInputStream)object3 : new BufferedInputStream((InputStream)object3, n3);
            return this.load(parameterBin, featureBin, labelText);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final POSPerceptron load(@NotNull InputStream parameterBin, @NotNull InputStream featureBin, @NotNull InputStream labelText) {
            String[] stringArray;
            void $this$toTypedArray$iv;
            List list;
            Intrinsics.checkParameterIsNotNull((Object)parameterBin, (String)"parameterBin");
            Intrinsics.checkParameterIsNotNull((Object)featureBin, (String)"featureBin");
            Intrinsics.checkParameterIsNotNull((Object)labelText, (String)"labelText");
            Perceptron model = PerceptronModel.Companion.loadWithFeatureBin(parameterBin, featureBin);
            model.decodeQuickMode(true);
            Object object = labelText;
            boolean bl = false;
            Throwable throwable = null;
            try {
                InputStream it = (InputStream)object;
                boolean bl2 = false;
                InputStream inputStream = it;
                Charset charset = Charsets.UTF_8;
                boolean bl3 = false;
                Closeable closeable = inputStream;
                int n = 0;
                closeable = new InputStreamReader((InputStream)closeable, charset);
                n = 8192;
                boolean bl4 = false;
                list = TextStreamsKt.readLines((Reader)(closeable instanceof BufferedReader ? (BufferedReader)closeable : new BufferedReader((Reader)closeable, n)));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
            List labelList = list;
            object = labelList;
            Perceptron perceptron = model;
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv = $this$toTypedArray$iv;
            String[] stringArray2 = thisCollection$iv.toArray(new String[0]);
            if (stringArray2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            String[] stringArray3 = stringArray = stringArray2;
            Perceptron perceptron2 = perceptron;
            return new POSPerceptron(perceptron2, stringArray3);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

