/*
 * Decompiled with CFR 0.152.
 */
package com.mayabot.nlp.segment.plugins.atom;

import com.mayabot.nlp.collection.dat.DoubleArrayTrieStringIntMap;
import com.mayabot.nlp.collection.dat.FastDatCharSet;
import com.mayabot.nlp.injector.Singleton;
import com.mayabot.nlp.segment.Nature;
import com.mayabot.nlp.segment.WordSplitAlgorithm;
import com.mayabot.nlp.segment.common.BaseSegmentComponent;
import com.mayabot.nlp.segment.common.String2;
import com.mayabot.nlp.segment.plugins.atom.AtomSplitAlgorithmTemplateProvider;
import com.mayabot.nlp.segment.wordnet.Wordnet;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Singleton
@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0016\u0010\f\u001a\n \u000e*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\n \u000e*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/mayabot/nlp/segment/plugins/atom/AtomSplitAlgorithm;", "Lcom/mayabot/nlp/segment/common/BaseSegmentComponent;", "Lcom/mayabot/nlp/segment/WordSplitAlgorithm;", "templateProvider", "Lcom/mayabot/nlp/segment/plugins/atom/AtomSplitAlgorithmTemplateProvider;", "(Lcom/mayabot/nlp/segment/plugins/atom/AtomSplitAlgorithmTemplateProvider;)V", "chineseNumSet", "Lcom/mayabot/nlp/collection/dat/FastDatCharSet;", "dat", "Lcom/mayabot/nlp/collection/dat/DoubleArrayTrieStringIntMap;", "getDat", "()Lcom/mayabot/nlp/collection/dat/DoubleArrayTrieStringIntMap;", "emailPattern", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "xPattern", "fill", "", "wordnet", "Lcom/mayabot/nlp/segment/wordnet/Wordnet;", "mynlp-segment"})
public final class AtomSplitAlgorithm
extends BaseSegmentComponent
implements WordSplitAlgorithm {
    @NotNull
    private final DoubleArrayTrieStringIntMap dat;
    private final FastDatCharSet chineseNumSet;
    private final Pattern emailPattern;
    private final Pattern xPattern;

    @NotNull
    public final DoubleArrayTrieStringIntMap getDat() {
        return this.dat;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void fill(@NotNull Wordnet wordnet) {
        char c;
        Intrinsics.checkParameterIsNotNull((Object)wordnet, (String)"wordnet");
        char[] cArray = wordnet.getCharArray();
        Intrinsics.checkExpressionValueIsNotNull((Object)cArray, (String)"wordnet.charArray");
        char[] chars = cArray;
        boolean foundNum = false;
        boolean foundAlpha = false;
        boolean foundAt = false;
        int n = 0;
        int n2 = chars.length;
        while (n < n2) {
            void i;
            c = chars[i];
            if (c < '{') {
                if (c >= '0' && c <= '9') {
                    foundNum = true;
                } else if (c >= 'a' && c <= 'Z' || c >= 'a' && c <= 'z') {
                    foundAlpha = true;
                }
            } else if (this.chineseNumSet.contains(c)) {
                foundNum = true;
            }
            if (foundAlpha || foundNum) break;
            ++i;
        }
        boolean foundBigX = false;
        if (foundNum || foundAlpha) {
            char[] newChars = Arrays.copyOf(chars, chars.length);
            c = '\u0000';
            int n3 = chars.length;
            while (c < n3) {
                void i;
                char c2 = chars[i];
                if (c2 < '{') {
                    if (c2 >= '0' && c2 <= '9') {
                        newChars[i] = 78;
                    } else if (c2 >= 'A' && c2 <= 'Z' || c2 >= 'a' && c2 <= 'z' || c2 == '_') {
                        newChars[i] = 65;
                    } else if (c2 == '.') {
                        newChars[i] = 78;
                    } else if (c2 == '@') {
                        foundAt = true;
                    }
                } else if (this.chineseNumSet.contains(c2)) {
                    newChars[i] = 90;
                }
                ++i;
            }
            DoubleArrayTrieStringIntMap.DATMapLongMatcherInt match = this.dat.matchLong(newChars, 0);
            int bigXEnd = -1;
            while (match.next()) {
                DoubleArrayTrieStringIntMap.DATMapLongMatcherInt dATMapLongMatcherInt = match;
                Intrinsics.checkExpressionValueIsNotNull((Object)dATMapLongMatcherInt, (String)"match");
                int type = dATMapLongMatcherInt.getValue();
                int offset = match.getBegin();
                int length = match.getLength();
                switch (type) {
                    case 0: {
                        wordnet.put(offset, length).setAbsWordNatureAndFreq(Nature.t);
                        break;
                    }
                    case 1: {
                        if (length == 1 && chars[offset] == '.') break;
                        if (offset == bigXEnd) {
                            foundBigX = true;
                        }
                        wordnet.put(offset, length).setAbsWordNatureAndFreq(Nature.m);
                        break;
                    }
                    case 2: {
                        wordnet.put(offset, length).setAbsWordNatureAndFreq(Nature.mq);
                        break;
                    }
                    case 3: {
                        wordnet.put(offset, length).setAbsWordNatureAndFreq(Nature.x);
                        bigXEnd = offset + length;
                        break;
                    }
                    case 4: {
                        if (offset != bigXEnd) break;
                        foundBigX = true;
                    }
                }
            }
            if (foundAt) {
                Matcher matcher = this.emailPattern.matcher(new String2(newChars));
                while (matcher.find()) {
                    wordnet.put(matcher.start(), matcher.end() - matcher.start()).setAbsWordNatureAndFreq(Nature.x);
                }
            }
            if (foundBigX) {
                Matcher matcher = this.xPattern.matcher(new String2(newChars));
                while (matcher.find()) {
                    wordnet.put(matcher.start(), matcher.end() - matcher.start()).setAbsWordNatureAndFreq(Nature.x);
                }
            }
        }
    }

    public AtomSplitAlgorithm(@NotNull AtomSplitAlgorithmTemplateProvider templateProvider) {
        Intrinsics.checkParameterIsNotNull((Object)templateProvider, (String)"templateProvider");
        super(-500);
        this.dat = templateProvider.load();
        this.chineseNumSet = new FastDatCharSet(new char[]{'\u96f6', '\u4e00', '\u4e8c', '\u4e09', '\u56db', '\u4e94', '\u516d', '\u4e03', '\u516b', '\u4e5d', '\u4e24', '\u58f9', '\u8d30', '\u53c1', '\u8086', '\u4f0d', '\u9646', '\u67d2', '\u634c', '\u7396', '\u62fe', '\u5341', '\u767e', '\u5343', '\u4e07', '\u4ebf'});
        this.emailPattern = Pattern.compile("[NA]+@[NA]+NA+");
        this.xPattern = Pattern.compile("A+[N\\-][N\\-A]*");
    }
}

