/*
 * Decompiled with CFR 0.152.
 */
package com.mayabot.nlp.segment;

import com.mayabot.nlp.segment.Lexer;
import com.mayabot.nlp.segment.WordTermSequence;
import com.mayabot.nlp.segment.reader.DefaultLexerReader;
import com.mayabot.nlp.segment.reader.PunctuationFilter;
import com.mayabot.nlp.segment.reader.StopWordDict;
import com.mayabot.nlp.segment.reader.StopwordFilter;
import java.io.Reader;

public interface LexerReader {
    public WordTermSequence scan(Reader var1);

    public WordTermSequence scan(String var1);

    public static LexerReader from(Lexer lexer) {
        return new DefaultLexerReader(lexer);
    }

    public static LexerReader filter(Lexer lexer, boolean punctuation, boolean stopWord) {
        LexerReader reader = new DefaultLexerReader(lexer);
        if (punctuation) {
            reader = new PunctuationFilter(reader);
        }
        if (stopWord) {
            reader = new StopwordFilter(reader);
        }
        return reader;
    }

    public static LexerReader filter(Lexer lexer, boolean punctuation, StopWordDict stopWord) {
        LexerReader reader = new DefaultLexerReader(lexer);
        if (punctuation) {
            reader = new PunctuationFilter(reader);
        }
        reader = new StopwordFilter(reader, stopWord);
        return reader;
    }
}

