/*
 * Decompiled with CFR 0.152.
 */
package com.mayabot.nlp.perceptron;

import com.mayabot.nlp.perceptron.FeatureSet;
import com.mayabot.nlp.perceptron.Perceptron;
import com.mayabot.nlp.perceptron.PerceptronModel;
import com.mayabot.nlp.perceptron.TrainSample;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0014\n\u0002\b\u0005\u0018\u00002\u00020\u0001Bk\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00126\u0010\t\u001a2\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\r\u0012\u0013\u0012\u00110\u000e\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\u000f\u0012\u0004\u0012\u00020\u00100\n\u0012\u0006\u0010\u0011\u001a\u00020\u0005\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\u0002\u0010\u0014J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J \u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0012\u0010\u0019\u001a\u00020\u000e2\b\b\u0002\u0010\u001a\u001a\u00020\u0005H\u0007J\b\u0010\u001b\u001a\u00020\u000eH\u0002J\u0010\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u0005H\u0002R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R>\u0010\t\u001a2\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\r\u0012\u0013\u0012\u00110\u000e\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\u000f\u0012\u0004\u0012\u00020\u00100\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/mayabot/nlp/perceptron/PerceptronTrainer;", "", "featureSet", "Lcom/mayabot/nlp/perceptron/FeatureSet;", "labelCount", "", "trainSource", "", "Lcom/mayabot/nlp/perceptron/TrainSample;", "evaluateScript", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "iter", "Lcom/mayabot/nlp/perceptron/Perceptron;", "perceptron", "", "maxIter", "decodeQuickModel_", "", "(Lcom/mayabot/nlp/perceptron/FeatureSet;ILjava/util/List;Lkotlin/jvm/functions/Function2;IZ)V", "buildPerceptronModel", "Lcom/mayabot/nlp/perceptron/PerceptronModel;", "parameter", "", "train", "threadNumber", "trainOneThread", "trainParallel", "mynlp-perceptron"})
public final class PerceptronTrainer {
    private final FeatureSet featureSet;
    private final int labelCount;
    private final List<TrainSample> trainSource;
    private final Function2<Integer, Perceptron, Unit> evaluateScript;
    private final int maxIter;
    private final boolean decodeQuickModel_;

    private final PerceptronModel buildPerceptronModel(FeatureSet featureSet2, int labelCount) {
        PerceptronModel perceptronModel = new PerceptronModel(featureSet2, labelCount);
        boolean bl = false;
        boolean bl2 = false;
        PerceptronModel $this$apply = perceptronModel;
        boolean bl3 = false;
        $this$apply.decodeQuickMode(this.decodeQuickModel_);
        return perceptronModel;
    }

    private final PerceptronModel buildPerceptronModel(FeatureSet featureSet2, int labelCount, float[] parameter) {
        PerceptronModel perceptronModel = new PerceptronModel(featureSet2, labelCount, parameter);
        boolean bl = false;
        boolean bl2 = false;
        PerceptronModel $this$apply = perceptronModel;
        boolean bl3 = false;
        $this$apply.decodeQuickMode(this.decodeQuickModel_);
        return perceptronModel;
    }

    @JvmOverloads
    @NotNull
    public final Perceptron train(int threadNumber) {
        return threadNumber == 1 ? this.trainOneThread() : this.trainParallel(threadNumber);
    }

    public static /* synthetic */ Perceptron train$default(PerceptronTrainer perceptronTrainer, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = Runtime.getRuntime().availableProcessors() - 1;
        }
        return perceptronTrainer.train(n);
    }

    @JvmOverloads
    @NotNull
    public final Perceptron train() {
        return PerceptronTrainer.train$default(this, 0, 1, null);
    }

    /*
     * WARNING - void declaration
     */
    private final Perceptron trainOneThread() {
        PerceptronModel model = this.buildPerceptronModel(this.featureSet, this.labelCount);
        double[] total = new double[model.getParameter().length];
        int[] timestamp = new int[model.getParameter().length];
        int current = 0;
        int n = 1;
        int n2 = this.maxIter;
        if (n <= n2) {
            while (true) {
                float[] back;
                void k;
                long t1 = System.currentTimeMillis();
                String string = "\n#ITER " + (int)k + '/' + this.maxIter;
                boolean bl = false;
                System.out.println((Object)string);
                string = "Process 0%";
                bl = false;
                System.out.print((Object)string);
                int per = 0;
                Object $this$forEach$iv = this.trainSource;
                boolean $i$f$forEach = false;
                Object object = $this$forEach$iv.iterator();
                while (object.hasNext()) {
                    String string2;
                    Object element$iv = object.next();
                    TrainSample it = (TrainSample)element$iv;
                    boolean bl2 = false;
                    int n3 = current;
                    current = n3 + 1;
                    model.update(it, total, timestamp, current);
                    n3 = per;
                    if ((per = n3 + 1) % 5000 != 0) continue;
                    String string3 = "%.2f";
                    Object[] objectArray = new Object[]{(double)per * 100.0 / (double)this.trainSource.size()};
                    StringBuilder stringBuilder = new StringBuilder().append("\rProcess ");
                    boolean bl3 = false;
                    Intrinsics.checkExpressionValueIsNotNull((Object)String.format(string3, Arrays.copyOf(objectArray, objectArray.length)), (String)"java.lang.String.format(this, *args)");
                    string3 = stringBuilder.append(string2).append('%').toString();
                    boolean bl4 = false;
                    System.out.print((Object)string3);
                }
                $this$forEach$iv = "\r";
                boolean bl5 = false;
                System.out.print($this$forEach$iv);
                long t2 = System.currentTimeMillis();
                object = "train use " + (t2 - t1) + " ms\n";
                boolean bl6 = false;
                System.out.println(object);
                float[] fArray = model.getParameter();
                int n4 = model.getParameter().length;
                boolean bl7 = false;
                Intrinsics.checkExpressionValueIsNotNull((Object)Arrays.copyOf(fArray, n4), (String)"java.util.Arrays.copyOf(this, newSize)");
                model.average(total, timestamp, current);
                this.evaluateScript.invoke((Object)((int)k), (Object)model);
                model.setParameter(back);
                if (k == n2) break;
                ++k;
            }
        }
        model.average(total, timestamp, current);
        return model;
    }

    /*
     * WARNING - void declaration
     */
    private final Perceptron trainParallel(int threadNumber) {
        Object[] objectArray = new PerceptronModel[threadNumber];
        int n = 0;
        while (n < threadNumber) {
            PerceptronModel perceptronModel;
            int n2 = n;
            int n3 = n++;
            Object[] objectArray2 = objectArray;
            boolean bl = false;
            objectArray2[n3] = perceptronModel = this.buildPerceptronModel(this.featureSet, this.labelCount);
        }
        Object[] modelArray = objectArray;
        ExecutorService executor = Executors.newFixedThreadPool(threadNumber);
        List parts = CollectionsKt.chunked((Iterable)this.trainSource, (int)((int)((double)this.trainSource.size() * 1.0 / (double)threadNumber) + 1));
        int it = 1;
        int n4 = this.maxIter;
        if (it <= n4) {
            while (true) {
                int n5;
                int i;
                void k;
                String string = "#ITER " + (int)k + '/' + this.maxIter;
                boolean bl = false;
                System.out.println((Object)string);
                long t1 = System.currentTimeMillis();
                CountDownLatch countDownLatch = new CountDownLatch(threadNumber);
                int n6 = 0;
                int n7 = threadNumber;
                while (n6 < n7) {
                    void s;
                    executor.submit(new Runnable(parts, (int)s, (PerceptronModel[])modelArray, countDownLatch){
                        final /* synthetic */ List $parts;
                        final /* synthetic */ int $s;
                        final /* synthetic */ PerceptronModel[] $modelArray;
                        final /* synthetic */ CountDownLatch $countDownLatch;

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public final void run() {
                            try {
                                boolean bl;
                                String string;
                                List list = (List)this.$parts.get(this.$s);
                                int count = 0;
                                if (this.$s == 0) {
                                    string = "Process 0%";
                                    bl = false;
                                    System.out.print((Object)string);
                                }
                                Iterable $this$forEach$iv = list;
                                boolean $i$f$forEach = false;
                                for (T element$iv : $this$forEach$iv) {
                                    String string2;
                                    TrainSample d = (TrainSample)element$iv;
                                    boolean bl2 = false;
                                    this.$modelArray[this.$s].update(d);
                                    int n = count;
                                    count = n + 1;
                                    if (this.$s != 0 || count % 5000 != 0) continue;
                                    String string3 = "%.2f";
                                    Object[] objectArray = new Object[]{(double)count * 100.0 / (double)list.size()};
                                    StringBuilder stringBuilder = new StringBuilder().append("\rProcess ");
                                    boolean bl3 = false;
                                    Intrinsics.checkExpressionValueIsNotNull((Object)String.format(string3, Arrays.copyOf(objectArray, objectArray.length)), (String)"java.lang.String.format(this, *args)");
                                    string3 = stringBuilder.append(string2).append('%').toString();
                                    boolean bl4 = false;
                                    System.out.println((Object)string3);
                                }
                                if (this.$s == 0) {
                                    string = "\r";
                                    bl = false;
                                    System.out.print((Object)string);
                                }
                            }
                            finally {
                                this.$countDownLatch.countDown();
                            }
                        }
                        {
                            this.$parts = list;
                            this.$s = n;
                            this.$modelArray = perceptronModelArray;
                            this.$countDownLatch = countDownLatch;
                        }
                    });
                    ++s;
                }
                countDownLatch.await();
                float[] first = ((PerceptronModel)ArraysKt.first((Object[])modelArray)).getParameter();
                n7 = 1;
                int n8 = modelArray.length;
                while (n7 < n8) {
                    float[] the = ((PerceptronModel)modelArray[i]).getParameter();
                    n5 = 0;
                    int n9 = first.length;
                    while (n5 < n9) {
                        void j;
                        void v0 = j;
                        first[v0] = first[v0] + the[j];
                        ++j;
                    }
                    ++i;
                }
                i = 0;
                n8 = first.length;
                while (i < n8) {
                    void j;
                    first[j] = first[j] / (float)modelArray.length;
                    ++j;
                }
                long t2 = System.currentTimeMillis();
                String string2 = "use " + (t2 - t1) + " ms\n";
                n5 = 0;
                System.out.println((Object)string2);
                this.evaluateScript.invoke((Object)((int)k), ArraysKt.first((Object[])modelArray));
                if (k == n4) break;
                ++k;
            }
        }
        executor.shutdownNow();
        return this.buildPerceptronModel(this.featureSet, this.labelCount, ((PerceptronModel)ArraysKt.first((Object[])modelArray)).getParameter());
    }

    public PerceptronTrainer(@NotNull FeatureSet featureSet2, int labelCount, @NotNull List<TrainSample> trainSource, @NotNull Function2<? super Integer, ? super Perceptron, Unit> evaluateScript, int maxIter, boolean decodeQuickModel_) {
        Intrinsics.checkParameterIsNotNull((Object)featureSet2, (String)"featureSet");
        Intrinsics.checkParameterIsNotNull(trainSource, (String)"trainSource");
        Intrinsics.checkParameterIsNotNull(evaluateScript, (String)"evaluateScript");
        this.featureSet = featureSet2;
        this.labelCount = labelCount;
        this.trainSource = trainSource;
        this.evaluateScript = evaluateScript;
        this.maxIter = maxIter;
        this.decodeQuickModel_ = decodeQuickModel_;
        boolean bl = this.featureSet.getKeys() != null;
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Check failed.";
            throw (Throwable)new IllegalStateException(string.toString());
        }
    }
}

