/*
 * Decompiled with CFR 0.152.
 */
package com.mayabot.nlp.resources;

import com.google.common.io.ByteSource;
import com.google.common.io.Resources;
import com.mayabot.nlp.logging.InternalLogger;
import com.mayabot.nlp.logging.InternalLoggerFactory;
import com.mayabot.nlp.resources.NlpResource;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;

public class URLNlpResource
implements NlpResource {
    static InternalLogger logger = InternalLoggerFactory.getInstance(URLNlpResource.class);
    private final URL url;
    private final Charset charset;

    public URLNlpResource(URL url, Charset charset) {
        this.url = url;
        this.charset = charset;
    }

    @Override
    public InputStream inputStream() throws IOException {
        ByteSource byteSource = Resources.asByteSource((URL)this.url);
        return byteSource.openBufferedStream();
    }

    public String toString() {
        return this.url.toString();
    }
}

