/*
 * Decompiled with CFR 0.152.
 */
package com.mayabot.nlp.hppc;

import com.mayabot.nlp.hppc.ArraySizingStrategy;
import com.mayabot.nlp.hppc.BoundedProportionalArraySizingStrategy;
import java.util.Arrays;

public class IntArrayList {
    public static final int DEFAULT_EXPECTED_ELEMENTS = 4;
    public static final int[] EMPTY_ARRAY = new int[0];
    public int[] buffer = EMPTY_ARRAY;
    public int elementsCount;
    protected final ArraySizingStrategy resizer;

    public IntArrayList() {
        this(4);
    }

    public IntArrayList(int expectedElements) {
        this(expectedElements, new BoundedProportionalArraySizingStrategy());
    }

    public IntArrayList(int expectedElements, ArraySizingStrategy resizer) {
        assert (resizer != null);
        this.resizer = resizer;
        this.ensureCapacity(expectedElements);
    }

    public void add(int e1) {
        this.ensureBufferSpace(1);
        this.buffer[this.elementsCount++] = e1;
    }

    public void add(int e1, int e2) {
        this.ensureBufferSpace(2);
        this.buffer[this.elementsCount++] = e1;
        this.buffer[this.elementsCount++] = e2;
    }

    public void add(int[] elements, int start, int length) {
        assert (length >= 0) : "Length must be >= 0";
        this.ensureBufferSpace(length);
        System.arraycopy(elements, start, this.buffer, this.elementsCount, length);
        this.elementsCount += length;
    }

    public final void add(int ... elements) {
        this.add(elements, 0, elements.length);
    }

    public int get(int index) {
        assert (index >= 0 && index < this.size()) : "Index " + index + " out of bounds [" + 0 + ", " + this.size() + ").";
        return this.buffer[index];
    }

    public int set(int index, int e1) {
        assert (index >= 0 && index < this.size()) : "Index " + index + " out of bounds [" + 0 + ", " + this.size() + ").";
        int v = this.buffer[index];
        this.buffer[index] = e1;
        return v;
    }

    public int remove(int index) {
        assert (index >= 0 && index < this.size()) : "Index " + index + " out of bounds [" + 0 + ", " + this.size() + ").";
        int v = this.buffer[index];
        if (index + 1 < this.elementsCount) {
            System.arraycopy(this.buffer, index + 1, this.buffer, index, this.elementsCount - index - 1);
        }
        --this.elementsCount;
        this.buffer[this.elementsCount] = 0;
        return v;
    }

    public boolean contains(int e1) {
        return this.indexOf(e1) >= 0;
    }

    public int indexOf(int e1) {
        for (int i = 0; i < this.elementsCount; ++i) {
            if (this.buffer[i] != e1) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(int e1) {
        for (int i = this.elementsCount - 1; i >= 0; --i) {
            if (this.buffer[i] != e1) continue;
            return i;
        }
        return -1;
    }

    public boolean isEmpty() {
        return this.elementsCount == 0;
    }

    public void ensureCapacity(int expectedElements) {
        int bufferLen;
        int n = bufferLen = this.buffer == null ? 0 : this.buffer.length;
        if (expectedElements > bufferLen) {
            this.ensureBufferSpace(expectedElements - this.size());
        }
    }

    protected void ensureBufferSpace(int expectedAdditions) {
        int bufferLen;
        int n = bufferLen = this.buffer == null ? 0 : this.buffer.length;
        if (this.elementsCount + expectedAdditions > bufferLen) {
            int newSize = this.resizer.grow(bufferLen, this.elementsCount, expectedAdditions);
            assert (newSize >= this.elementsCount + expectedAdditions) : "Resizer failed to return sensible new size: " + newSize + " <= " + (this.elementsCount + expectedAdditions);
            this.buffer = Arrays.copyOf(this.buffer, newSize);
        }
    }

    public void resize(int newSize) {
        if (newSize <= this.buffer.length) {
            if (newSize < this.elementsCount) {
                Arrays.fill(this.buffer, newSize, this.elementsCount, 0);
            } else {
                Arrays.fill(this.buffer, this.elementsCount, newSize, 0);
            }
        } else {
            this.ensureCapacity(newSize);
        }
        this.elementsCount = newSize;
    }

    public int size() {
        return this.elementsCount;
    }

    public void trimToSize() {
        if (this.size() != this.buffer.length) {
            this.buffer = this.toArray();
        }
    }

    public void clear() {
        Arrays.fill(this.buffer, 0, this.elementsCount, 0);
        this.elementsCount = 0;
    }

    public void release() {
        this.buffer = EMPTY_ARRAY;
        this.elementsCount = 0;
    }

    public int[] toArray() {
        return Arrays.copyOf(this.buffer, this.elementsCount);
    }

    public IntArrayList clone() {
        try {
            IntArrayList cloned = (IntArrayList)super.clone();
            cloned.buffer = (int[])this.buffer.clone();
            return cloned;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public int hashCode() {
        int h = 1;
        int max = this.elementsCount;
        for (int i = 0; i < max; ++i) {
            h = 31 * h + IntArrayList.mix32(this.buffer[i]);
        }
        return h;
    }

    public boolean equals(Object obj) {
        return obj != null && this.getClass() == obj.getClass() && this.equalElements((IntArrayList)this.getClass().cast(obj));
    }

    private static int mix32(int k) {
        k = (k ^ k >>> 16) * -2048144789;
        k = (k ^ k >>> 13) * -1028477387;
        return k ^ k >>> 16;
    }

    protected boolean equalElements(IntArrayList other) {
        int max = this.size();
        if (other.size() != max) {
            return false;
        }
        for (int i = 0; i < max; ++i) {
            if (other.get(i) == this.get(i)) continue;
            return false;
        }
        return true;
    }

    public static IntArrayList from(int ... elements) {
        IntArrayList list = new IntArrayList(elements.length);
        list.add(elements);
        return list;
    }
}

