/*
 * Decompiled with CFR 0.152.
 */
package com.mayabot.nlp.common.matrix;

import com.google.common.base.Splitter;
import com.google.common.collect.ArrayTable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Table;
import com.google.common.collect.UnmodifiableIterator;
import com.google.common.io.ByteSource;
import com.mayabot.nlp.common.QuickStringDoubleTable;
import com.mayabot.nlp.common.QuickStringIntTable;
import com.mayabot.nlp.resources.NlpResource;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TransformMatrix {
    private QuickStringIntTable matrix;
    private ImmutableMap<String, Long> total;
    private long totalFrequency;
    public ImmutableList<String> states;
    public ImmutableMap<String, Double> start_probability;
    public QuickStringDoubleTable transititon_probability;

    public double getTP(String a, String b) {
        double d = this.transititon_probability.get(a, b);
        if (d == Double.MIN_VALUE) {
            return 0.0;
        }
        return d;
    }

    public int getFrequency(String from, String to) {
        int v = this.matrix.get(from, to);
        if (v == Integer.MIN_VALUE) {
            return 0;
        }
        return v;
    }

    public boolean load(ByteSource source) throws IOException {
        try (InputStream inputStream = source.openBufferedStream();){
            boolean bl = this.load(inputStream);
            return bl;
        }
    }

    public boolean load(NlpResource resource) throws IOException {
        try (InputStream inputStream = resource.inputStream();){
            boolean bl = this.load(inputStream);
            return bl;
        }
    }

    public boolean load(InputStream in) throws IOException {
        Splitter splitter = Splitter.on((char)',').trimResults();
        try (BufferedReader br = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));){
            String line;
            String firstLine = br.readLine();
            List lablist = splitter.splitToList((CharSequence)firstLine);
            ArrayTable matrix = ArrayTable.create(lablist.subList(1, lablist.size()), lablist.subList(1, lablist.size()));
            while ((line = br.readLine()) != null) {
                List paramArray = splitter.splitToList((CharSequence)line);
                String row_lable = (String)paramArray.get(0);
                Map row = matrix.row((Object)row_lable);
                for (int i = 1; i < paramArray.size(); ++i) {
                    row.put(lablist.get(i), Integer.parseInt((String)paramArray.get(i)));
                }
            }
            this.matrix = new QuickStringIntTable((Table<String, String, Integer>)matrix);
            this.tongji((ArrayTable<String, String, Integer>)matrix);
        }
        return true;
    }

    private void tongji(ArrayTable<String, String, Integer> matrix) {
        HashMap _total = Maps.newHashMap();
        for (String label : matrix.rowKeyList()) {
            int x;
            long v1 = 0L;
            long v2 = 0L;
            UnmodifiableIterator unmodifiableIterator = matrix.row((Object)label).values().iterator();
            while (unmodifiableIterator.hasNext()) {
                x = (Integer)unmodifiableIterator.next();
                v1 += (long)x;
            }
            unmodifiableIterator = matrix.column((Object)label).values().iterator();
            while (unmodifiableIterator.hasNext()) {
                x = (Integer)unmodifiableIterator.next();
                v2 += (long)x;
            }
            _total.put(label, v1 + v2 - (long)((Integer)matrix.get((Object)label, (Object)label)).intValue());
        }
        this.total = ImmutableMap.copyOf((Map)_total);
        long _tf = 0L;
        UnmodifiableIterator v1 = this.total.values().iterator();
        while (v1.hasNext()) {
            long x = (Long)v1.next();
            _tf += x;
        }
        this.totalFrequency = _tf;
        this.states = matrix.rowKeyList();
        HashMap _start_probability = Maps.newHashMap();
        for (String label : this.states) {
            double frequency = (double)((Long)this.total.get((Object)label)).longValue() + 1.0E-8;
            _start_probability.put(label, -Math.log(frequency / (double)this.totalFrequency));
        }
        this.start_probability = ImmutableMap.copyOf((Map)_start_probability);
        ArrayTable transititon_probability = ArrayTable.create((Iterable)matrix.rowKeyList(), (Iterable)matrix.columnKeyList());
        for (String from : this.states) {
            for (String to : this.states) {
                double frequency = (double)((Integer)matrix.get((Object)from, (Object)to)).intValue() + 1.0E-8;
                transititon_probability.put((Object)from, (Object)to, (Object)(-Math.log(frequency / (double)((Long)this.total.get((Object)from)).longValue())));
            }
        }
        this.transititon_probability = new QuickStringDoubleTable((Table<String, String, Double>)transititon_probability);
    }

    public long getTotalFrequency(String from) {
        Long v = (Long)this.total.get((Object)from);
        if (v == null) {
            return 0L;
        }
        return v;
    }

    public long getTotalFrequency() {
        return this.totalFrequency;
    }
}

