/*
 * Decompiled with CFR 0.152.
 */
package com.mayabot.nlp.common.matrix;

import com.google.common.collect.Table;
import com.google.common.collect.TreeBasedTable;
import com.mayabot.nlp.utils.DataInOutputUtils;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Map;
import java.util.SortedMap;

public class CSRSparseMatrix
implements Serializable {
    private int[] rowOffset;
    private int[] columnIndices;
    private int[] values;

    public CSRSparseMatrix(int[] rowOffset, int[] columnIndices, int[] values) {
        this.rowOffset = rowOffset;
        this.columnIndices = columnIndices;
        this.values = values;
    }

    public int[] getRowOffset() {
        return this.rowOffset;
    }

    public int[] getColumnIndices() {
        return this.columnIndices;
    }

    public int[] getValues() {
        return this.values;
    }

    public CSRSparseMatrix() {
    }

    public CSRSparseMatrix(TreeBasedTable<Integer, Integer, Integer> table, int totalRow) {
        int size = table.size();
        this.values = new int[size];
        this.columnIndices = new int[size];
        this.rowOffset = new int[totalRow + 1];
        int point = -1;
        int inSize = 0;
        for (Integer rowNum : table.rowKeySet()) {
            SortedMap row = table.row((Object)rowNum);
            this.rowOffset[rowNum.intValue() + 1] = inSize += row.size();
            for (Map.Entry entry : row.entrySet()) {
                this.columnIndices[++point] = (Integer)entry.getKey();
                this.values[point] = (Integer)entry.getValue();
            }
        }
        int x = 0;
        for (int i = 0; i < this.rowOffset.length; ++i) {
            int p = this.rowOffset[i];
            if (p > 0) {
                x = p;
                continue;
            }
            this.rowOffset[i] = x;
        }
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        DataInOutputUtils.writeIntArray(this.getColumnIndices(), (DataOutput)out);
        DataInOutputUtils.writeIntArray(this.getRowOffset(), (DataOutput)out);
        DataInOutputUtils.writeIntArray(this.getValues(), (DataOutput)out);
    }

    public void readExternal(ObjectInput in) throws IOException {
        this.columnIndices = DataInOutputUtils.readIntArray(in);
        this.rowOffset = DataInOutputUtils.readIntArray(in);
        this.values = DataInOutputUtils.readIntArray(in);
    }

    public int get(int row, int col) {
        if (row < 0 || col < 0) {
            return 0;
        }
        int off = this.rowOffset[row];
        int end = this.rowOffset[row + 1];
        if (off == end) {
            return 0;
        }
        int index = Arrays.binarySearch(this.columnIndices, off, end, col);
        if (index >= 0) {
            return this.values[index];
        }
        return 0;
    }

    public static void main(String[] args) {
        TreeBasedTable table = TreeBasedTable.create();
        table.put((Object)2, (Object)0, (Object)6);
        table.put((Object)3, (Object)2, (Object)4);
        table.put((Object)0, (Object)0, (Object)5);
        table.put((Object)0, (Object)3, (Object)2);
        table.put((Object)4, (Object)1, (Object)2);
        table.put((Object)4, (Object)4, (Object)9);
        CSRSparseMatrix csr = new CSRSparseMatrix((TreeBasedTable<Integer, Integer, Integer>)table, 5);
        for (Table.Cell cell : table.cellSet()) {
            if (csr.get((Integer)cell.getRowKey(), (Integer)cell.getColumnKey()) == ((Integer)cell.getValue()).intValue()) {
                System.out.println(String.format("%d->%d = %d", cell.getRowKey(), cell.getColumnKey(), cell.getValue()));
                continue;
            }
            System.out.println("ERROR");
        }
    }
}

