/*
 * Decompiled with CFR 0.152.
 */
package com.mayabot.nlp.common;

import com.google.common.collect.Lists;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;

public class QuickStringDoubleTable {
    private int[] labelBase;
    private int labelSize;
    double[] data;

    public QuickStringDoubleTable(Table<String, String, Double> table) {
        ArrayList labelList = Lists.newArrayList((Iterable)table.rowKeySet());
        this.labelBase = QuickStringDoubleTable.findABase(labelList);
        this.labelSize = this.labelBase.length;
        this.data = new double[this.labelSize * this.labelSize];
        for (String rowKey : table.rowKeySet()) {
            for (String colKey : table.columnKeySet()) {
                int rowid = this.labelBase[rowKey.hashCode() % this.labelSize];
                int colid = this.labelBase[colKey.hashCode() % this.labelSize];
                this.data[rowid * this.labelSize + colid] = (Double)table.get((Object)rowKey, (Object)colKey);
            }
        }
    }

    public double get(String row, String col) {
        int rowid = this.labelBase[row.hashCode() % this.labelSize];
        int colid = this.labelBase[col.hashCode() % this.labelSize];
        if (rowid == -1 || colid == -1) {
            return Double.MIN_VALUE;
        }
        return this.data[rowid * this.labelSize + colid];
    }

    public static int[] findABase(List<String> tags) {
        int len = tags.size() * 10;
        for (int i = 0; i < Integer.MAX_VALUE; ++i) {
            HashSet<Integer> set = new HashSet<Integer>();
            boolean notGood = false;
            for (String tag : tags) {
                int code = tag.hashCode() % len;
                if (set.contains(code)) {
                    notGood = true;
                    break;
                }
                set.add(code);
            }
            if (notGood) {
                ++len;
                continue;
            }
            int[] base = new int[len];
            Arrays.fill(base, -1);
            int i1 = 0;
            while (i1 < tags.size()) {
                String tag = tags.get(i1);
                int index = tag.hashCode() % base.length;
                base[index] = i1++;
            }
            return base;
        }
        throw new RuntimeException("findBase not find");
    }
}

