/*
 * Decompiled with CFR 0.152.
 */
package com.mayabot.nlp.common;

import com.mayabot.nlp.common.FastCharReader;
import com.mayabot.nlp.common.ParagraphReader;
import com.mayabot.nlp.common.ParagraphReaderString;
import com.mayabot.nlp.utils.Characters;
import java.io.IOException;
import java.io.Reader;

public class ParagraphReaderSmart
implements ParagraphReader {
    private FastCharReader fastCharReader;
    private int expectSize;
    private int pad;
    private int max;
    private static final int minPad = 128;
    private static final int defaultExpect = 640;
    private int offset = -1;
    private int lastlen = -1;

    public static ParagraphReader prepare(String string) {
        if (string.length() < 256) {
            return new ParagraphReaderString(string);
        }
        return new ParagraphReaderSmart(new FastCharReader(string));
    }

    public ParagraphReaderSmart(Reader reader) {
        this(reader, 640);
    }

    public ParagraphReaderSmart(Reader reader, int expect) {
        this.fastCharReader = new FastCharReader(reader);
        this.expectsize(expect);
    }

    public ParagraphReaderSmart(FastCharReader reader) {
        this(reader, 640);
    }

    public ParagraphReaderSmart(FastCharReader reader, int expect) {
        this.fastCharReader = reader;
        this.expectsize(expect);
    }

    private void expectsize(int expect) {
        this.expectSize = expect;
        this.pad = Math.max(128, this.expectSize / 2);
        this.max = this.expectSize + this.pad;
    }

    public int offset() {
        return this.offset;
    }

    @Override
    public String next() throws IOException {
        int l;
        StringBuilder result = new StringBuilder(this.max);
        int count = 0;
        while (count < this.max && (l = this.fastCharReader.read()) != -1) {
            char _ch = (char)l;
            result.append(_ch);
            if (++count <= this.expectSize || !Characters.isPunctuation(_ch)) continue;
            break;
        }
        if (this.offset == -1) {
            this.offset = 0;
            this.lastlen = result.length();
        } else {
            this.offset += this.lastlen;
            this.lastlen = result.length();
        }
        if (result.length() == 0) {
            return null;
        }
        return result.toString();
    }
}

