/*
 * Decompiled with CFR 0.152.
 */
package com.mayabot.nlp.common;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.nio.CharBuffer;

public class FastCharReader {
    private Reader reader;
    private CharBuffer buffer;
    private int capacity = 128;
    private int offset = -1;

    public FastCharReader(Reader reader) {
        this.reader = reader;
    }

    public FastCharReader(String string) {
        this.reader = new StringReader(string);
        if (string.length() < 256) {
            this.capacity = Math.max(string.length(), 4);
        }
    }

    public FastCharReader(Reader reader, int capacity) {
        this.reader = reader;
        this.capacity = Math.max(capacity, 4);
    }

    public int offset() {
        return this.offset;
    }

    public void reset(Reader reader) {
        this.reader = reader;
        this.buffer = null;
        this.offset = -1;
    }

    public int read() throws IOException {
        if (this.buffer == null) {
            this.buffer = CharBuffer.allocate(this.capacity);
            this.reader.read(this.buffer);
            this.buffer.flip();
        } else if (!this.buffer.hasRemaining()) {
            this.buffer.clear();
            this.reader.read(this.buffer);
            this.buffer.flip();
        }
        if (this.buffer.hasRemaining()) {
            ++this.offset;
            return this.buffer.get();
        }
        return -1;
    }

    public static void main(String[] args) throws IOException {
        String string = "";
        FastCharReader r = new FastCharReader(new StringReader(string));
        long t1 = System.currentTimeMillis();
        for (int i = 0; i < 1; ++i) {
            r.reset(new StringReader(string));
            int c = -1;
            while ((c = r.read()) != -1) {
                System.out.println(r.offset + " : " + (char)c);
            }
        }
        long t2 = System.currentTimeMillis();
        System.out.println(t2 - t1);
        System.out.println("string length " + string.length());
    }

    public static void main2(String[] args) throws IOException {
        String string = "\n\u5f53\u8bfb\u53d6\u6570\u636e\u65f6\uff0c\u4e5f\u662f\u4ece\u67d0\u4e2a\u7279\u5b9a\u4f4d\u7f6e\u8bfb\u3002\u5f53\u5c06Buffer\u4ece\u5199\u6a21\u5f0f\u5207\u6362\u5230\u8bfb\u6a21\u5f0f\uff0cposition\u4f1a\u88ab\u91cd\u7f6e\u4e3a0. \u5f53\u4eceBuffer\u7684position\u5904\u8bfb\u53d6\u6570\u636e\u65f6\uff0cposition\u5411\u524d\u79fb\u52a8\u5230\u4e0b\u4e00\u4e2a\u53ef\u8bfb\u7684\u4f4d\u7f6e\u3002\nlimit\n\n\u5728\u5199\u6a21\u5f0f\u4e0b\uff0cBuffer\u7684limit\u8868\u793a\u4f60\u6700\u591a\u80fd\u5f80Buffer\u91cc\u5199\u591a\u5c11\u6570\u636e\u3002 \u5199\u6a21\u5f0f\u4e0b\uff0climit\u7b49\u4e8eBuffer\u7684capacity\u3002\n\n\u5f53\u5207\u6362Buffer\u5230\u8bfb\u6a21\u5f0f\u65f6\uff0c limit\u8868\u793a\u4f60\u6700\u591a\u80fd\u8bfb\u5230\u591a\u5c11\u6570\u636e\u3002\u56e0\u6b64\uff0c\u5f53\u5207\u6362Buffer\u5230\u8bfb\u6a21\u5f0f\u65f6\uff0climit\u4f1a\u88ab\u8bbe\u7f6e\u6210\u5199\u6a21\u5f0f\u4e0b\u7684position\u503c\u3002\u6362\u53e5\u8bdd\u8bf4\uff0c\u4f60\u80fd\u8bfb\u5230\u4e4b\u524d\u5199\u5165\u7684\u6240\u6709\u6570\u636e\uff08limit\u88ab\u8bbe\u7f6e\u6210\u5df2\u5199\u6570\u636e\u7684\u6570\u91cf\uff0c\u8fd9\u4e2a\u503c\u5728\u5199\u6a21\u5f0f\u4e0b\u5c31\u662fposition\uff09";
        FastCharReader r = new FastCharReader(new StringReader(string));
        r.read();
        r.read();
        long t1 = System.currentTimeMillis();
        for (int i = 0; i < 100000; ++i) {
            r.reset(new StringReader(string));
            int c = -1;
            while ((c = r.read()) != -1) {
            }
        }
        long t2 = System.currentTimeMillis();
        System.out.println(t2 - t1);
        System.out.println("string length " + string.length());
    }
}

