/*
 * Decompiled with CFR 0.152.
 */
package com.mayabot.nlp.collection.dat;

import com.mayabot.nlp.collection.dat.DATLongMatcher;
import com.mayabot.nlp.collection.dat.DATMatcher;
import com.mayabot.nlp.collection.dat.DoubleArrayTrie;
import com.mayabot.nlp.utils.DataInOutputUtils;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.TreeMap;

public class DoubleArrayTrieStringIntMap {
    private int[] values;
    private DoubleArrayTrie dat;

    public DoubleArrayTrieStringIntMap(DataInput in) throws IOException {
        DoubleArrayTrie dat = new DoubleArrayTrie(in);
        int[] values = DataInOutputUtils.readIntArray(in);
        this.dat = dat;
        this.values = values;
    }

    public DoubleArrayTrieStringIntMap(DoubleArrayTrie dat, int[] values) {
        this.values = values;
        this.dat = dat;
    }

    public DoubleArrayTrieStringIntMap(ArrayList<String> keys, int[] values) {
        this(new DoubleArrayTrie(keys), values);
    }

    public DoubleArrayTrieStringIntMap(TreeMap<String, Integer> map) {
        ArrayList<String> keys = new ArrayList<String>(map.keySet());
        int[] values = new int[map.size()];
        Collection<Integer> values1 = map.values();
        int c = 0;
        for (Integer integer : values1) {
            values[c++] = integer;
        }
        this.dat = new DoubleArrayTrie(keys);
        this.values = values;
    }

    public void save(DataOutput out) throws IOException {
        this.dat.write(out);
        DataInOutputUtils.writeIntArray(this.values, out);
    }

    public DATMapMatcherInt match(String text, int offset) {
        return new DATMapMatcherInt(this.dat.matcher(text, offset));
    }

    public DATMapLongMatcherInt matchLong(char[] text, int offset) {
        return new DATMapLongMatcherInt(this.dat.matcherLong(text, offset));
    }

    public DATMapLongMatcherInt matchLong(String text, int offset) {
        return new DATMapLongMatcherInt(this.dat.matcherLong(text, offset));
    }

    public DATMapMatcherInt match(char[] text, int offset) {
        return new DATMapMatcherInt(this.dat.matcher(text, offset));
    }

    public int size() {
        return this.values.length;
    }

    public int indexOf(CharSequence key) {
        return this.dat.indexOf(key, 0, 0, 0);
    }

    public int indexOf(CharSequence key, int pos, int len, int nodePos) {
        return this.dat.indexOf(key, pos, len, nodePos);
    }

    public int indexOf(char[] chars, int pos, int len) {
        return this.dat.indexOf(chars, pos, len, 0);
    }

    public int indexOf(char[] keyChars, int pos, int len, int nodePos) {
        return this.dat.indexOf(keyChars, pos, len, nodePos);
    }

    public int indexOf(char ch) {
        return this.dat.indexOf(ch);
    }

    public int get(CharSequence key) {
        int index = this.indexOf(key);
        if (index >= 0) {
            return this.getValueAt(index);
        }
        return -1;
    }

    public int get(CharSequence key, int offset, int length) {
        int index = this.indexOf(key, offset, length, 0);
        if (index >= 0) {
            return this.getValueAt(index);
        }
        return -1;
    }

    public int get(char[] key) {
        int index = this.indexOf(key, 0, key.length, 0);
        if (index >= 0) {
            return this.getValueAt(index);
        }
        return -1;
    }

    public int get(char[] key, int offset, int len) {
        int index = this.indexOf(key, offset, len, 0);
        if (index >= 0) {
            return this.getValueAt(index);
        }
        return -1;
    }

    public int getValueAt(int index) {
        return this.values[index];
    }

    public boolean containsKey(String key) {
        return this.indexOf(key) >= 0;
    }

    public boolean containsKey(char key) {
        return this.indexOf(key) >= 0;
    }

    public boolean set(String key, int value) {
        int index = this.indexOf(key);
        if (index >= 0) {
            this.values[index] = value;
            return true;
        }
        return false;
    }

    public int get(int index) {
        return this.values[index];
    }

    public class DATMapLongMatcherInt {
        DATLongMatcher datMater;

        public DATMapLongMatcherInt(DATLongMatcher datMater) {
            this.datMater = datMater;
        }

        public boolean next() {
            return this.datMater.next();
        }

        public int getBegin() {
            return this.datMater.getBegin();
        }

        public int getLength() {
            return this.datMater.getLength();
        }

        public int getValue() {
            int index = this.datMater.getIndex();
            if (index == -1) {
                return -1;
            }
            return DoubleArrayTrieStringIntMap.this.values[index];
        }

        public int getIndex() {
            return this.datMater.getIndex();
        }
    }

    public class DATMapMatcherInt {
        DATMatcher datMater;

        public DATMapMatcherInt(DATMatcher datMater) {
            this.datMater = datMater;
        }

        public boolean next() {
            return this.datMater.next();
        }

        public int getBegin() {
            return this.datMater.getBegin();
        }

        public int getLength() {
            return this.datMater.getLength();
        }

        public int getValue() {
            int index = this.datMater.getIndex();
            if (index == -1) {
                return -1;
            }
            return DoubleArrayTrieStringIntMap.this.values[index];
        }

        public int getIndex() {
            return this.datMater.getIndex();
        }
    }
}

