/*
 * Decompiled with CFR 0.152.
 */
package com.mayabot.nlp.collection.dat;

import com.mayabot.nlp.collection.Trie;
import com.mayabot.nlp.collection.dat.DATMapMatcher;
import com.mayabot.nlp.collection.dat.DATMatcher;
import com.mayabot.nlp.collection.dat.DoubleArrayTrie;
import com.mayabot.nlp.utils.DataInOutputUtils;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import java.util.function.BiConsumer;
import java.util.function.Function;

public class DoubleArrayTrieMap<T>
implements Trie<T> {
    private ArrayList<T> values;
    private DoubleArrayTrie dat;

    public DoubleArrayTrieMap(DataInput in, Function<DataInput, T> supplier) throws IOException {
        DoubleArrayTrie dat = new DoubleArrayTrie(in);
        ArrayList<T> values = DataInOutputUtils.readArrayList(in, supplier);
        this.dat = dat;
        this.values = values;
    }

    public DoubleArrayTrieMap(DoubleArrayTrie dat, ArrayList<T> values) {
        this.values = values;
        this.dat = dat;
    }

    public DoubleArrayTrieMap(TreeMap<String, T> treeMap) {
        ArrayList<String> keys = new ArrayList<String>(treeMap.size());
        ArrayList values = new ArrayList(treeMap.size());
        treeMap.forEach((a, b) -> {
            keys.add((String)a);
            values.add(b);
        });
        this.dat = new DoubleArrayTrie(keys);
        this.values = values;
    }

    public DoubleArrayTrieMap(List<String> keys, ArrayList<T> values) {
        this(new DoubleArrayTrie(keys), values);
    }

    public void save(DataOutput out, BiConsumer<T, DataOutput> biConsumer) throws IOException {
        this.dat.write(out);
        DataInOutputUtils.writeArrayList(this.values, biConsumer, out);
    }

    public DATMapMatcher<T> match(String text, int offset) {
        return new DATMapMatcherInner(this.dat.matcher(text, offset));
    }

    public DATMapMatcher<T> match(char[] text, int offset) {
        return new DATMapMatcherInner(this.dat.matcher(text, offset));
    }

    public int size() {
        return this.values.size();
    }

    public int indexOf(CharSequence key) {
        return this.dat.indexOf(key, 0, 0, 0);
    }

    public int indexOf(CharSequence key, int pos, int len, int nodePos) {
        return this.dat.indexOf(key, pos, len, nodePos);
    }

    public int indexOf(char[] chars, int pos, int len) {
        return this.dat.indexOf(chars, pos, len, 0);
    }

    public int indexOf(char[] keyChars, int pos, int len, int nodePos) {
        return this.dat.indexOf(keyChars, pos, len, nodePos);
    }

    @Override
    public T get(CharSequence key) {
        int index = this.indexOf(key);
        if (index >= 0) {
            return this.getValueAt(index);
        }
        return null;
    }

    public T get(CharSequence key, int offset, int length) {
        int index = this.indexOf(key, offset, length, 0);
        if (index >= 0) {
            return this.getValueAt(index);
        }
        return null;
    }

    @Override
    public T get(char[] key) {
        int index = this.indexOf(key, 0, key.length, 0);
        if (index >= 0) {
            return this.getValueAt(index);
        }
        return null;
    }

    @Override
    public T get(char[] key, int offset, int len) {
        int index = this.indexOf(key, offset, len, 0);
        if (index >= 0) {
            return this.getValueAt(index);
        }
        return null;
    }

    public T getValueAt(int index) {
        return this.values.get(index);
    }

    @Override
    public boolean containsKey(String key) {
        return this.indexOf(key) >= 0;
    }

    public boolean set(String key, T value) {
        int index = this.indexOf(key);
        if (index >= 0) {
            this.values.set(index, value);
            return true;
        }
        return false;
    }

    public T get(int index) {
        return this.values.get(index);
    }

    class DATMapMatcherInner<T>
    implements DATMapMatcher<T> {
        DATMatcher datMater;

        public DATMapMatcherInner(DATMatcher datMater) {
            this.datMater = datMater;
        }

        @Override
        public boolean next() {
            return this.datMater.next();
        }

        @Override
        public int getBegin() {
            return this.datMater.getBegin();
        }

        @Override
        public int getLength() {
            return this.datMater.getLength();
        }

        @Override
        public T getValue() {
            int index = this.datMater.getIndex();
            if (index == -1) {
                return null;
            }
            return (T)DoubleArrayTrieMap.this.values.get(index);
        }

        @Override
        public int getIndex() {
            return this.datMater.getIndex();
        }
    }
}

