/*
 * Decompiled with CFR 0.152.
 */
package com.mayabot.nlp.collection.bintrie;

import com.mayabot.nlp.collection.bintrie.BinTrieNode;
import com.mayabot.nlp.collection.bintrie.BinTrieTree;
import com.mayabot.nlp.collection.bintrie.TrieTreeMatcher;
import java.util.List;

public class TrieTreeForwardMaxMatcher<T>
implements TrieTreeMatcher<T> {
    private static final String EMPTY_STRING = "";
    private final BinTrieTree<T> tree;
    private int offset;
    private int root;
    private int i;
    private boolean isBack;
    private BinTrieNode<T> branch;
    private String text;
    private String str;
    private int tempOffset;
    private final int len;
    private T param;

    TrieTreeForwardMaxMatcher(BinTrieTree<T> tree, String content) {
        this.i = this.root = 0;
        this.isBack = false;
        this.text = content;
        this.tree = tree;
        this.branch = tree;
        this.len = content.length();
    }

    @Override
    public String next() {
        String temp = this.frontWordNext();
        while (EMPTY_STRING.equals(temp)) {
            temp = this.frontWordNext();
        }
        return temp;
    }

    private String frontWordNext() {
        int up = this.len + 1;
        while (this.i < up) {
            this.branch = this.i == this.len ? null : this.branch.findChild(this.text.charAt(this.i));
            if (this.branch == null) {
                this.branch = this.tree;
                if (this.isBack) {
                    this.offset = this.root;
                    this.str = this.text.substring(this.root, this.root + this.tempOffset);
                    if (this.root > 0 && this.isE(this.text.charAt(this.root - 1)) && this.isE(this.str.charAt(0))) {
                        this.str = EMPTY_STRING;
                    }
                    if (this.str.length() != 0 && this.root + this.tempOffset < this.text.length() && this.isE(this.str.charAt(this.str.length() - 1)) && this.isE(this.text.charAt(this.root + this.tempOffset))) {
                        this.str = EMPTY_STRING;
                    }
                    if (this.str.length() == 0) {
                        ++this.root;
                        this.i = this.root;
                    } else {
                        this.root = this.i = this.root + this.tempOffset;
                    }
                    this.isBack = false;
                    if (EMPTY_STRING.equals(this.str)) {
                        return EMPTY_STRING;
                    }
                    return this.str;
                }
                this.i = this.root++;
            } else {
                switch (this.branch.getStatus()) {
                    case 2: {
                        this.isBack = true;
                        this.tempOffset = this.i - this.root + 1;
                        this.param = this.branch.getValue();
                        break;
                    }
                    case 3: {
                        this.offset = this.root;
                        String temp = this.str = this.text.substring(this.root, this.i + 1);
                        if (this.root > 0 && this.isE(this.text.charAt(this.root - 1)) && this.isE(this.str.charAt(0))) {
                            this.str = EMPTY_STRING;
                        }
                        if (this.str.length() != 0 && this.i + 1 < this.text.length() && this.isE(this.str.charAt(this.str.length() - 1)) && this.isE(this.text.charAt(this.i + 1))) {
                            this.str = EMPTY_STRING;
                        }
                        this.param = this.branch.getValue();
                        this.branch = this.tree;
                        this.isBack = false;
                        if (temp.length() > 0) {
                            ++this.i;
                            this.root = this.i;
                        } else {
                            this.i = this.root + 1;
                        }
                        if (EMPTY_STRING.equals(this.str)) {
                            return EMPTY_STRING;
                        }
                        return this.str;
                    }
                }
            }
            ++this.i;
        }
        this.tempOffset += this.len;
        return null;
    }

    private boolean isE(char c) {
        return c == '.' || c >= 'a' && c <= 'z';
    }

    @Override
    public String getParam(int i) {
        if (this.param != null) {
            if (this.param instanceof String[]) {
                String[] _p = (String[])this.param;
                if (_p.length > i) {
                    return _p[i];
                }
            } else if (this.param instanceof List) {
                List list = (List)this.param;
                return (String)list.get(i);
            }
        }
        return null;
    }

    @Override
    public T getParams() {
        return this.param;
    }

    @Override
    public int getOffset() {
        return this.offset;
    }
}

