/*
 * Decompiled with CFR 0.152.
 */
package com.mayabot.nlp.collection.bintrie;

import com.mayabot.nlp.collection.bintrie.ArrayTrieNode;
import com.mayabot.nlp.collection.bintrie.BinTrieTree;
import com.mayabot.nlp.collection.bintrie.HashTrieNode;
import java.util.Map;
import java.util.function.Function;

public enum BinTrieTreeBuilder {
    _default(false, HashTrieNode::new),
    bigArray(false, ArrayTrieNode::new),
    bigHash(false, ArrayTrieNode::new),
    miniArray(true, ArrayTrieNode::new),
    miniHash(true, HashTrieNode::new);

    private boolean rootUseMap;
    BinTrieTree.TrieNodeFactory nodeFactory;

    private BinTrieTreeBuilder(boolean rootUseMap, BinTrieTree.TrieNodeFactory nodeFactory) {
        this.rootUseMap = rootUseMap;
        this.nodeFactory = nodeFactory;
    }

    public <T> BinTrieTree<T> build() {
        return new BinTrieTree(this.rootUseMap, this.nodeFactory);
    }

    public <T> BinTrieTree<T> build(Map<String, T> map) {
        BinTrieTree<T> tree = new BinTrieTree<T>(this.rootUseMap, this.nodeFactory);
        for (Map.Entry<String, T> entry : map.entrySet()) {
            tree.put(entry.getKey(), entry.getValue());
        }
        return tree;
    }

    public <T> BinTrieTree<T> build(String split, Iterable<String> lines, Function<String[], T> transFun) {
        BinTrieTree<T> tree = new BinTrieTree<T>(this.rootUseMap, this.nodeFactory);
        String[] empty = new String[]{};
        for (String line : lines) {
            String[] list = line.split(split);
            if (list.length == 1) {
                tree.put(list[0], transFun.apply(empty));
                continue;
            }
            String[] sublist = new String[list.length - 1];
            System.arraycopy(list, 1, sublist, 0, sublist.length);
            tree.put(list[0], transFun.apply(sublist));
        }
        return tree;
    }
}

