/*
 * Decompiled with CFR 0.152.
 */
package com.mayabot.nlp.collection.ahocorasick;

import com.mayabot.nlp.collection.ahocorasick.Hit;
import com.mayabot.nlp.collection.ahocorasick.IHit;
import com.mayabot.nlp.collection.ahocorasick.IHitFull;
import com.mayabot.nlp.utils.DataInOutputUtils;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;

public class AhoCorasickDoubleArrayTrie<V> {
    int[] check;
    int[] base;
    int[] fail;
    int[][] output;
    ArrayList<V> values;
    int[] keylength;

    AhoCorasickDoubleArrayTrie() {
    }

    public static <T> void write(AhoCorasickDoubleArrayTrie<T> dat, DataOutput out, BiConsumer<T, DataOutput> biConsumer) throws IOException {
        DataInOutputUtils.writeIntArray(dat.check, out);
        DataInOutputUtils.writeIntArray(dat.keylength, out);
        DataInOutputUtils.writeIntArray(dat.base, out);
        DataInOutputUtils.writeIntArray(dat.fail, out);
        DataInOutputUtils.writeArrayList(dat.values, biConsumer, out);
        DataInOutputUtils.writeIntArray(dat.output, out);
    }

    public static <T> AhoCorasickDoubleArrayTrie<T> read(DataInput in, Function<DataInput, T> function) throws IOException {
        AhoCorasickDoubleArrayTrie x = new AhoCorasickDoubleArrayTrie();
        x.check = DataInOutputUtils.readIntArray(in);
        x.keylength = DataInOutputUtils.readIntArray(in);
        x.base = DataInOutputUtils.readIntArray(in);
        x.fail = DataInOutputUtils.readIntArray(in);
        x.values = DataInOutputUtils.readArrayList(in, function);
        x.output = DataInOutputUtils.readDoubleIntArray(in);
        return x;
    }

    public List<Hit<V>> parseText(CharSequence text) {
        int position = 1;
        int currentState = 0;
        LinkedList<Hit<V>> collectedEmits = new LinkedList<Hit<V>>();
        for (int i = 0; i < text.length(); ++i) {
            currentState = this.getState(currentState, text.charAt(i));
            this.storeEmits(position, currentState, collectedEmits);
            ++position;
        }
        return collectedEmits;
    }

    public void parseText(CharSequence text, IHit<V> processor) {
        int position = 1;
        int currentState = 0;
        for (int i = 0; i < text.length(); ++i) {
            int[] hitArray = this.output[currentState = this.getState(currentState, text.charAt(i))];
            if (hitArray != null) {
                for (int hit : hitArray) {
                    processor.hit(position - this.keylength[hit], position, this.values.get(hit));
                }
            }
            ++position;
        }
    }

    public void parseText(char[] text, IHit<V> processor) {
        int position = 1;
        int currentState = 0;
        for (char c : text) {
            int[] hitArray = this.output[currentState = this.getState(currentState, c)];
            if (hitArray != null) {
                for (int hit : hitArray) {
                    processor.hit(position - this.keylength[hit], position, this.values.get(hit));
                }
            }
            ++position;
        }
    }

    public void parseText(char[] text, IHitFull<V> processor) {
        int position = 1;
        int currentState = 0;
        for (char c : text) {
            int[] hitArray = this.output[currentState = this.getState(currentState, c)];
            if (hitArray != null) {
                for (int hit : hitArray) {
                    processor.hit(position - this.keylength[hit], position, this.values.get(hit), hit);
                }
            }
            ++position;
        }
    }

    public V get(String key) {
        int index = this.exactMatchSearch(key);
        if (index >= 0) {
            return this.values.get(index);
        }
        return null;
    }

    public boolean set(String key, V value) {
        int index = this.exactMatchSearch(key);
        if (index >= 0) {
            this.values.set(index, value);
            return true;
        }
        return false;
    }

    public V get(int index) {
        return this.values.get(index);
    }

    private int getState(int currentState, char character) {
        int newCurrentState = this.transitionWithRoot(currentState, character);
        while (newCurrentState == -1) {
            currentState = this.fail[currentState];
            newCurrentState = this.transitionWithRoot(currentState, character);
        }
        return newCurrentState;
    }

    private void storeEmits(int position, int currentState, List<Hit<V>> collectedEmits) {
        int[] hitArray = this.output[currentState];
        if (hitArray != null) {
            for (int hit : hitArray) {
                collectedEmits.add(new Hit<V>(position - this.keylength[hit], position, this.values.get(hit)));
            }
        }
    }

    protected int transition(int current, char c) {
        int b = current;
        int p = b + c + 1;
        if (b != this.check[p]) {
            return -1;
        }
        b = this.base[p];
        p = b;
        return p;
    }

    protected int transitionWithRoot(int nodePos, char c) {
        int b = this.base[nodePos];
        int p = b + c + 1;
        if (b != this.check[p]) {
            if (nodePos == 0) {
                return 0;
            }
            return -1;
        }
        return p;
    }

    public int exactMatchSearch(String key) {
        return this.exactMatchSearch(key, 0, 0, 0);
    }

    private int exactMatchSearch(String key, int pos, int len, int nodePos) {
        int p;
        if (len <= 0) {
            len = key.length();
        }
        if (nodePos <= 0) {
            nodePos = 0;
        }
        int result = -1;
        int b = this.base[nodePos];
        for (int i = pos; i < len; ++i) {
            p = b + key.codePointAt(i) + 1;
            if (b != this.check[p]) {
                return result;
            }
            b = this.base[p];
        }
        p = b;
        int n = this.base[p];
        if (b == this.check[p] && n < 0) {
            result = -n - 1;
        }
        return result;
    }

    int exactMatchSearch(char[] keyChars, int pos, int len, int nodePos) {
        int p;
        int result = -1;
        int b = this.base[nodePos];
        for (int i = pos; i < len; ++i) {
            p = b + keyChars[i] + 1;
            if (b != this.check[p]) {
                return result;
            }
            b = this.base[p];
        }
        p = b;
        int n = this.base[p];
        if (b == this.check[p] && n < 0) {
            result = -n - 1;
        }
        return result;
    }

    public int size() {
        return this.values.size();
    }
}

