/*
 * Decompiled with CFR 0.152.
 */
package com.mayabot.nlp.collection.ahocorasick;

import com.mayabot.nlp.collection.ahocorasick.AhoCorasickDoubleArrayTrie;
import com.mayabot.nlp.collection.ahocorasick.State;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.LinkedBlockingDeque;

public class AhoCoraickDoubleArrayTrieBuilder<V> {
    private State rootState = new State();
    private BitSet used;
    private int progress;
    private int nextCheckPos;
    private int size;
    private AhoCorasickDoubleArrayTrie<V> trie = new AhoCorasickDoubleArrayTrie();
    final int default_capacity = 0x100000;
    private int array_capacity = 0x100000;

    public AhoCoraickDoubleArrayTrieBuilder() {
        this.used = new BitSet();
    }

    public AhoCorasickDoubleArrayTrie<V> build(TreeMap<String, V> map) {
        this.trie.values = new ArrayList<V>(map.values());
        this.trie.keylength = new int[this.trie.values.size()];
        this.trie.base = new int[this.array_capacity];
        this.trie.check = new int[this.array_capacity];
        Set<String> keySet = map.keySet();
        this.addAllKeyword(keySet);
        this.buildDoubleArrayTrie(keySet);
        this.constructFailureStates();
        this.rootState = null;
        this.loseWeight();
        return this.trie;
    }

    private int fetch(State parent, List<Map.Entry<Integer, State>> siblings) {
        if (parent.isAcceptable()) {
            State fakeNode = new State(-(parent.getDepth() + 1));
            fakeNode.addEmit(parent.getLargestValueId());
            siblings.add(new AbstractMap.SimpleEntry<Integer, State>(0, fakeNode));
        }
        for (Map.Entry<Character, State> entry : parent.getSuccess().entrySet()) {
            siblings.add(new AbstractMap.SimpleEntry<Integer, State>(entry.getKey().charValue() + '\u0001', entry.getValue()));
        }
        return siblings.size();
    }

    private void addKeyword(String keyword, int index) {
        State currentState = this.rootState;
        char[] cArray = keyword.toCharArray();
        int n = cArray.length;
        for (int i = 0; i < n; ++i) {
            Character character = Character.valueOf(cArray[i]);
            currentState = currentState.addState(character);
        }
        currentState.addEmit(index);
        this.trie.keylength[index] = keyword.length();
    }

    private void addAllKeyword(Collection<String> keywordSet) {
        int i = 0;
        for (String keyword : keywordSet) {
            this.addKeyword(keyword, i++);
        }
    }

    private void constructFailureStates() {
        this.trie.fail = new int[this.size + 1];
        this.trie.fail[1] = this.trie.base[0];
        this.trie.output = new int[this.size + 1][];
        LinkedBlockingDeque<State> queue = new LinkedBlockingDeque<State>();
        for (State depthOneState : this.rootState.getStates()) {
            depthOneState.setFailure(this.rootState, this.trie.fail);
            queue.add(depthOneState);
            this.constructOutput(depthOneState);
        }
        while (!queue.isEmpty()) {
            State currentState = (State)queue.remove();
            for (Character transition : currentState.getTransitions()) {
                State targetState = currentState.nextState(transition);
                queue.add(targetState);
                State traceFailureState = currentState.failure();
                while (traceFailureState.nextState(transition) == null) {
                    traceFailureState = traceFailureState.failure();
                }
                State newFailureState = traceFailureState.nextState(transition);
                targetState.setFailure(newFailureState, this.trie.fail);
                targetState.addEmit(newFailureState.emit());
                this.constructOutput(targetState);
            }
        }
    }

    private void constructOutput(State targetState) {
        Collection<Integer> emit = targetState.emit();
        if (emit == null || emit.size() == 0) {
            return;
        }
        int[] output = new int[emit.size()];
        Iterator<Integer> it = emit.iterator();
        for (int i = 0; i < output.length; ++i) {
            output[i] = it.next();
        }
        this.trie.output[targetState.getIndex()] = output;
    }

    private void buildDoubleArrayTrie(Set<String> keySet) {
        this.progress = 0;
        this.resize(0x200000);
        this.trie.base[0] = 1;
        this.nextCheckPos = 0;
        State root_node = this.rootState;
        ArrayList<Map.Entry<Integer, State>> siblings = new ArrayList<Map.Entry<Integer, State>>(root_node.getSuccess().entrySet().size());
        this.fetch(root_node, siblings);
        this.insert(siblings);
    }

    private void resize(int new_capacity) {
        if (new_capacity <= this.array_capacity) {
            return;
        }
        if (new_capacity - this.array_capacity < 65536) {
            new_capacity = this.array_capacity + 65536;
        }
        int[] base2 = new int[new_capacity];
        int[] check2 = new int[new_capacity];
        System.arraycopy(this.trie.base, 0, base2, 0, this.array_capacity);
        System.arraycopy(this.trie.check, 0, check2, 0, this.array_capacity);
        this.trie.base = base2;
        this.trie.check = check2;
        this.array_capacity = new_capacity;
    }

    private int insert(List<Map.Entry<Integer, State>> siblings) {
        int begin = 0;
        int pos = Math.max(siblings.get(0).getKey() + 1, this.nextCheckPos) - 1;
        int nonzero_num = 0;
        boolean first = false;
        if (this.array_capacity <= pos) {
            this.resize(pos + 1);
        }
        block0: while (true) {
            if (this.array_capacity <= ++pos) {
                this.resize(pos + 1);
            }
            if (this.trie.check[pos] != 0) {
                ++nonzero_num;
                continue;
            }
            if (!first) {
                this.nextCheckPos = pos;
                first = true;
            }
            if (this.array_capacity <= (begin = pos - siblings.get(0).getKey()) + siblings.get(siblings.size() - 1).getKey()) {
                this.resize(begin + siblings.get(siblings.size() - 1).getKey() + 65536);
            }
            if (this.used.get(begin)) continue;
            for (int i = 1; i < siblings.size(); ++i) {
                if (this.trie.check[begin + siblings.get(i).getKey()] == 0) continue;
                continue block0;
            }
            break;
        }
        if (1.0 * (double)nonzero_num / (double)(pos - this.nextCheckPos + 1) >= 0.95) {
            this.nextCheckPos = pos;
        }
        this.used.set(begin);
        this.size = this.size > begin + siblings.get(siblings.size() - 1).getKey() + 1 ? this.size : begin + siblings.get(siblings.size() - 1).getKey() + 1;
        for (Map.Entry<Integer, State> sibling : siblings) {
            this.trie.check[begin + sibling.getKey().intValue()] = begin;
        }
        for (Map.Entry<Integer, State> sibling : siblings) {
            ArrayList<Map.Entry<Integer, State>> new_siblings = new ArrayList<Map.Entry<Integer, State>>(sibling.getValue().getSuccess().entrySet().size() + 1);
            if (this.fetch(sibling.getValue(), new_siblings) == 0) {
                this.trie.base[begin + sibling.getKey().intValue()] = -sibling.getValue().getLargestValueId().intValue() - 1;
                ++this.progress;
            } else {
                int h;
                this.trie.base[begin + sibling.getKey().intValue()] = h = this.insert(new_siblings);
            }
            sibling.getValue().setIndex(begin + sibling.getKey());
        }
        return begin;
    }

    private void loseWeight() {
        int[] nbase = new int[this.size + 65535];
        System.arraycopy(this.trie.base, 0, nbase, 0, this.size);
        this.trie.base = nbase;
        int[] ncheck = new int[this.size + 65535];
        System.arraycopy(this.trie.check, 0, ncheck, 0, this.size);
        this.trie.check = ncheck;
    }
}

