/*
 * Decompiled with CFR 0.152.
 */
package com.mayabot.nlp;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.Files;
import com.google.common.io.Resources;
import com.mayabot.nlp.SettingItem;
import com.mayabot.nlp.logging.InternalLogger;
import com.mayabot.nlp.logging.InternalLoggerFactory;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.Supplier;

public class Settings {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(Settings.class);
    private Map<String, String> settings;
    public static final Settings EMPTY = new Settings(Maps.newHashMap());

    Settings(Map<String, String> settings) {
        this.settings = Maps.newHashMap(settings);
    }

    Settings(Settings settings) {
        this.settings = Maps.newHashMap(settings.settings);
    }

    public <T> T get(SettingItem<T> setting) {
        String value = this.get(setting.getKey(), setting.getDefaultValue());
        return setting.getParse().apply(value);
    }

    public Settings put(SettingItem setting, String value) {
        this.settings.put(setting.getKey(), value);
        return this;
    }

    public Settings put(String key, String value) {
        this.settings.put(key, value);
        return this;
    }

    public Settings put(String prefix, SettingItem setting, String value) {
        this.settings.put(prefix + "." + setting.getKey(), value);
        return this;
    }

    public static Settings merge(Settings ... settings) {
        HashMap all = Maps.newHashMap();
        for (Settings setting : settings) {
            if (setting == null) continue;
            all.putAll(setting.settings);
        }
        return new Settings((Map<String, String>)ImmutableMap.copyOf((Map)all));
    }

    public static Settings createEmpty() {
        return new Settings((Map<String, String>)ImmutableMap.of());
    }

    public static Settings create(Map<String, String> settings) {
        return new Settings(settings);
    }

    public static Settings create(Properties properties) {
        HashMap<String, String> map = new HashMap<String, String>(16);
        for (String key : properties.stringPropertyNames()) {
            String value = properties.getProperty(key);
            map.put(key, value);
        }
        return new Settings(map);
    }

    public String get(String setting) {
        return this.settings.get(setting);
    }

    public String get(String setting, String defaultValue) {
        return this.settings.getOrDefault(setting, defaultValue);
    }

    public List<String> getAsList(SettingItem<String> setting) {
        return this.getAsList(setting.getKey(), setting.getDefaultValue());
    }

    public List<String> getAsList(String setting, String default_) {
        String obj = this.get(setting, default_);
        if (obj == null) {
            return null;
        }
        return Splitter.on((char)',').omitEmptyStrings().trimResults().splitToList((CharSequence)obj);
    }

    public Settings getByPrefix(String prefix) {
        if (!prefix.endsWith(".")) {
            prefix = prefix + ".";
        }
        String _prefix = prefix;
        Map sub = Maps.filterKeys(this.settings, key -> key.startsWith(_prefix));
        HashMap result = Maps.newHashMap();
        for (Map.Entry entry : sub.entrySet()) {
            result.put(((String)entry.getKey()).substring(_prefix.length()), entry.getValue());
        }
        return new Settings((Map<String, String>)ImmutableMap.copyOf((Map)result));
    }

    public Float getAsFloat(String setting, Float defaultValue) {
        String sValue = this.get(setting);
        if (sValue == null) {
            return defaultValue;
        }
        try {
            return Float.valueOf(Float.parseFloat(sValue));
        }
        catch (NumberFormatException e) {
            throw new SettingsException("Failed to parse float setting [" + setting + "] with value [" + sValue + "]", e);
        }
    }

    public Double getAsDouble(String setting, Double defaultValue) {
        String sValue = this.get(setting);
        if (sValue == null) {
            return defaultValue;
        }
        try {
            return Double.parseDouble(sValue);
        }
        catch (NumberFormatException e) {
            throw new SettingsException("Failed to parse double setting [" + setting + "] with value [" + sValue + "]", e);
        }
    }

    public Integer getAsInt(String setting, Integer defaultValue) {
        String sValue = this.get(setting);
        if (sValue == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(sValue);
        }
        catch (NumberFormatException e) {
            throw new SettingsException("Failed to parse int setting [" + setting + "] with value [" + sValue + "]", e);
        }
    }

    public Long getAsLong(String setting, Long defaultValue) {
        String sValue = this.get(setting);
        if (sValue == null) {
            return defaultValue;
        }
        try {
            return Long.parseLong(sValue);
        }
        catch (NumberFormatException e) {
            throw new SettingsException("Failed to parse long setting [" + setting + "] with value [" + sValue + "]", e);
        }
    }

    public Boolean getAsBoolean(String setting, Boolean defaultValue) {
        String value = this.get(setting, defaultValue.toString());
        return Boolean.valueOf(value);
    }

    public static Settings defaultSystemSettings() {
        ArrayList list = Lists.newArrayList((Object[])new Supplier[]{() -> {
            try {
                File file = new File("mynlp.properties");
                if (file.exists() && file.canRead()) {
                    logger.info("read settings from " + file);
                    return Files.asByteSource((File)file).openBufferedStream();
                }
            }
            catch (Exception e) {
                return null;
            }
            return null;
        }, () -> {
            try {
                InputStream inputStream = Resources.getResource((String)"mynlp.properties").openStream();
                logger.info("read settings from classpath://mynlp.properties");
                return inputStream;
            }
            catch (Exception e) {
                return null;
            }
        }, () -> {
            try {
                String userHome = System.getProperty("user.home");
                File file = new File(userHome, "mynlp.properties");
                if (file.exists() && file.canRead()) {
                    logger.info("read settings from " + file);
                    return Files.asByteSource((File)file).openBufferedStream();
                }
            }
            catch (Exception e) {
                return null;
            }
            return null;
        }});
        HashMap map = Maps.newHashMap();
        for (Supplier supplier : Lists.reverse((List)list)) {
            InputStream in = (InputStream)supplier.get();
            if (in == null) continue;
            Properties properties = new Properties();
            try {
                properties.load(in);
                for (String key : properties.stringPropertyNames()) {
                    String value = properties.getProperty(key);
                    map.put(key, value);
                }
            }
            catch (Exception exception) {
            }
        }
        return new Settings(map);
    }

    public static class SettingsException
    extends RuntimeException {
        public SettingsException(String message) {
            super(message);
        }

        public SettingsException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

