/*
 * Decompiled with CFR 0.152.
 */
package com.mayabot.nlp;

import java.util.function.Function;

public class SettingItem<T> {
    private String key;
    private String defaultValue;
    private Function<String, T> parse;

    private SettingItem() {
    }

    public String getKey() {
        return this.key;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public Function<String, T> getParse() {
        return this.parse;
    }

    public static SettingItem<Integer> intSetting(String key, int value) {
        SettingItem<Integer> setting = new SettingItem<Integer>();
        setting.key = key;
        setting.defaultValue = value + "";
        setting.parse = Integer::parseInt;
        return setting;
    }

    public static SettingItem<String> string(String key, String value) {
        SettingItem<String> setting = new SettingItem<String>();
        setting.key = key;
        setting.defaultValue = value;
        setting.parse = Function.identity();
        return setting;
    }

    public static SettingItem<Boolean> boolSetting(String key, boolean value) {
        SettingItem<Boolean> setting = new SettingItem<Boolean>();
        setting.key = key;
        setting.defaultValue = value + "";
        setting.parse = v -> v.equalsIgnoreCase("true");
        return setting;
    }
}

