/*
 * Decompiled with CFR 0.152.
 */
package com.mayabot.nlp;

import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableList;
import com.mayabot.nlp.SettingItem;
import com.mayabot.nlp.Settings;
import com.mayabot.nlp.logging.InternalLogger;
import com.mayabot.nlp.logging.InternalLoggerFactory;
import com.mayabot.nlp.resources.NlpResource;
import com.mayabot.nlp.resources.NlpResourceFactory;
import java.io.File;
import java.nio.charset.Charset;
import java.security.AccessController;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MynlpEnv {
    public static InternalLogger logger = InternalLoggerFactory.getInstance(MynlpEnv.class);
    private File dataDir;
    private File cacheDir;
    private List<NlpResourceFactory> resourceFactory;
    private Settings settings;

    MynlpEnv(File dataDir, File cacheDir, List<NlpResourceFactory> resourceFactory, Settings settings) {
        this.dataDir = dataDir;
        this.cacheDir = cacheDir;
        this.resourceFactory = ImmutableList.copyOf(resourceFactory);
        this.settings = settings;
    }

    public Settings getSettings() {
        return this.settings;
    }

    public void set(String key, String value) {
        this.settings.put(key, value);
    }

    @Nullable
    public String get(String setting) {
        return this.settings.get(setting);
    }

    public String get(String setting, @NotNull String defaultValue) {
        return this.settings.get(setting, defaultValue);
    }

    public <T> T get(SettingItem<T> setting) {
        return this.settings.get(setting);
    }

    @Nullable
    public NlpResource loadResource(String resourcePath) {
        return this.loadResource(resourcePath, Charsets.UTF_8);
    }

    @NotNull
    public NlpResource loadResource(String resourcePath, Charset charset) {
        if (resourcePath == null || resourcePath.trim().isEmpty()) {
            throw new RuntimeException("resourcePath is null");
        }
        return AccessController.doPrivileged(() -> {
            String wiki = "https://github.com/mayabot/mynlp/wiki/resources";
            NlpResource resource = this.getNlpResource(resourcePath, charset);
            if (resource == null) {
                throw new RuntimeException("Resource " + resourcePath + ", Not Found!\nResource Jar not in your maven or gradle dependencies \nOr ${mynlp.data} Dir\n\nAccess Wiki +" + wiki + " For help!");
            }
            return resource;
        });
    }

    @Nullable
    public String hashResource(String resourceName) {
        NlpResource r1 = this.tryLoadResource(resourceName, Charsets.UTF_8);
        if (r1 != null) {
            return r1.hash();
        }
        return null;
    }

    @Nullable
    public NlpResource tryLoadResource(String resourcePath, Charset charset) {
        return AccessController.doPrivileged(() -> {
            if (resourcePath == null || resourcePath.trim().isEmpty()) {
                return null;
            }
            return this.getNlpResource(resourcePath, charset);
        });
    }

    @Nullable
    public NlpResource tryLoadResource(String resourcePath) {
        return this.tryLoadResource(resourcePath, Charsets.UTF_8);
    }

    @Nullable
    public NlpResource tryLoadResource(SettingItem<String> resourceNameSetting) {
        return this.tryLoadResource(this.settings.get(resourceNameSetting), Charsets.UTF_8);
    }

    private synchronized NlpResource getNlpResource(String resourceName, Charset charset) {
        NlpResource resource = null;
        long t1 = System.currentTimeMillis();
        for (NlpResourceFactory factory : this.resourceFactory) {
            resource = factory.load(resourceName, charset);
            if (resource == null) continue;
            String string = resource.toString();
            if (string.length() >= 100) {
                string = "../.." + string.substring(string.length() - 60);
            }
            long t2 = System.currentTimeMillis();
            logger.info("load resource {} ,use time {} ms", (Object)string, (Object)(t2 - t1));
            break;
        }
        return resource;
    }

    public File getDataDir() {
        return this.dataDir;
    }

    public File getCacheDir() {
        return this.cacheDir;
    }
}

