/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.tracing;

import brave.Span;
import com.linecorp.armeria.common.RpcRequest;
import com.linecorp.armeria.common.Scheme;
import com.linecorp.armeria.common.SerializationFormat;
import com.linecorp.armeria.common.SessionProtocol;
import com.linecorp.armeria.common.logging.RequestLog;
import com.linecorp.armeria.internal.tracing.SpanContextUtil;
import java.net.SocketAddress;
import javax.annotation.Nullable;

public final class SpanTags {
    private static final String WIRE_SEND_ANNOTATION = "ws";
    private static final String WIRE_RECEIVE_ANNOTATION = "wr";

    public static void addTags(Span span, RequestLog log) {
        Object requestContent;
        SocketAddress laddr;
        SocketAddress raddr;
        Throwable responseCause;
        Scheme scheme = log.scheme();
        String authority = log.requestHeaders().authority();
        String path = log.path();
        assert (authority != null);
        span.tag("http.host", authority).tag("http.method", log.method().name()).tag("http.path", path).tag("http.url", SpanTags.generateUrl(scheme, authority, path, log.query())).tag("http.status_code", log.status().codeAsText()).tag("http.protocol", scheme.sessionProtocol().uriText());
        SerializationFormat serFmt = scheme.serializationFormat();
        if (serFmt != SerializationFormat.NONE) {
            span.tag("http.serfmt", serFmt.uriText());
        }
        if ((responseCause = log.responseCause()) != null) {
            span.tag("error", responseCause.toString());
        }
        if ((raddr = log.context().remoteAddress()) != null) {
            span.tag("address.remote", raddr.toString());
        }
        if ((laddr = log.context().localAddress()) != null) {
            span.tag("address.local", laddr.toString());
        }
        if ((requestContent = log.requestContent()) instanceof RpcRequest) {
            span.name(((RpcRequest)requestContent).method());
        }
    }

    private static String generateUrl(Scheme scheme, String authority, String path, @Nullable String query) {
        SessionProtocol sessionProtocol = scheme.sessionProtocol();
        String uriScheme = SessionProtocol.httpValues().contains(sessionProtocol) ? "http://" : (SessionProtocol.httpsValues().contains(sessionProtocol) ? "https://" : sessionProtocol.uriText() + "://");
        StringBuilder uriBuilder = new StringBuilder(uriScheme.length() + authority.length() + path.length() + (query != null ? query.length() + 1 : 0));
        uriBuilder.append(uriScheme).append(authority).append(path);
        if (query != null) {
            uriBuilder.append('?').append(query);
        }
        return uriBuilder.toString();
    }

    public static void logWireSend(Span span, long wireSendTimeNanos, RequestLog requestLog) {
        span.annotate(SpanContextUtil.wallTimeMicros(requestLog, wireSendTimeNanos), WIRE_SEND_ANNOTATION);
    }

    public static void logWireReceive(Span span, long wireSendTimeNanos, RequestLog requestLog) {
        span.annotate(SpanContextUtil.wallTimeMicros(requestLog, wireSendTimeNanos), WIRE_RECEIVE_ANNOTATION);
    }

    private SpanTags() {
    }
}

