/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common.tracing;

import brave.Tracing;
import brave.propagation.CurrentTraceContext;
import brave.propagation.TraceContext;
import com.linecorp.armeria.common.RequestContext;
import com.linecorp.armeria.internal.shaded.guava.annotations.VisibleForTesting;
import io.netty.util.Attribute;
import io.netty.util.AttributeKey;
import java.util.Collections;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RequestContextCurrentTraceContext
extends CurrentTraceContext {
    public static final CurrentTraceContext DEFAULT;
    @Deprecated
    public static final CurrentTraceContext INSTANCE;
    private static final Logger logger;
    private static final AttributeKey<TraceContext> TRACE_CONTEXT_KEY;
    private static final ThreadLocal<TraceContext> THREAD_LOCAL_CONTEXT;
    private static final CurrentTraceContext.Scope INCOMPLETE_CONFIGURATION_SCOPE;
    private static final CurrentTraceContext.Scope INITIAL_REQUEST_SCOPE;

    public static CurrentTraceContext.Builder newBuilder() {
        return new Builder();
    }

    public static void ensureScopeUsesRequestContext(Tracing tracing) {
        boolean scopeUsesRequestContext;
        PingPongExtra extra = new PingPongExtra();
        TraceContext dummyContext = TraceContext.newBuilder().traceId(1L).spanId(1L).extra(Collections.singletonList(extra)).build();
        try (CurrentTraceContext.Scope scope = tracing.currentTraceContext().newScope(dummyContext);){
            scopeUsesRequestContext = extra.isPong();
        }
        if (!scopeUsesRequestContext) {
            throw new IllegalStateException("Tracing.currentTraceContext is not a " + RequestContextCurrentTraceContext.class.getSimpleName() + " scope. Please call Tracing.Builder.currentTraceContext(" + RequestContextCurrentTraceContext.class.getSimpleName() + ".INSTANCE).");
        }
    }

    public static void copy(RequestContext src, RequestContext dst) {
        dst.attr(TRACE_CONTEXT_KEY).set((Object)((TraceContext)src.attr(TRACE_CONTEXT_KEY).get()));
    }

    private RequestContextCurrentTraceContext(Builder builder) {
        super((CurrentTraceContext.Builder)builder);
    }

    @Nullable
    public TraceContext get() {
        RequestContext ctx = RequestContextCurrentTraceContext.getRequestContextOrWarnOnce();
        if (ctx == null) {
            return null;
        }
        if (ctx.eventLoop().inEventLoop()) {
            return (TraceContext)ctx.attr(TRACE_CONTEXT_KEY).get();
        }
        TraceContext threadLocalContext = THREAD_LOCAL_CONTEXT.get();
        if (threadLocalContext != null) {
            return threadLocalContext;
        }
        return (TraceContext)ctx.attr(TRACE_CONTEXT_KEY).get();
    }

    public CurrentTraceContext.Scope newScope(@Nullable TraceContext currentSpan) {
        if (currentSpan != null && PingPongExtra.maybeSetPong(currentSpan)) {
            return CurrentTraceContext.Scope.NOOP;
        }
        RequestContext ctx = RequestContextCurrentTraceContext.getRequestContextOrWarnOnce();
        if (ctx == null) {
            return INCOMPLETE_CONFIGURATION_SCOPE;
        }
        if (ctx.eventLoop().inEventLoop()) {
            return RequestContextCurrentTraceContext.createScopeForRequestThread(ctx, currentSpan);
        }
        return RequestContextCurrentTraceContext.createScopeForNonRequestThread(currentSpan);
    }

    private static CurrentTraceContext.Scope createScopeForRequestThread(RequestContext ctx, @Nullable TraceContext currentSpan) {
        Attribute traceContextAttribute = ctx.attr(TRACE_CONTEXT_KEY);
        TraceContext previous = (TraceContext)traceContextAttribute.getAndSet((Object)currentSpan);
        if (previous == null) {
            return INITIAL_REQUEST_SCOPE;
        }
        class RequestContextTraceContextScope
        implements CurrentTraceContext.Scope {
            final /* synthetic */ TraceContext val$previous;

            RequestContextTraceContextScope(TraceContext traceContext) {
                this.val$previous = traceContext;
            }

            public void close() {
                RequestContextCurrentTraceContext.getTraceContextAttributeOrWarnOnce().set((Object)this.val$previous);
            }

            public String toString() {
                return "RequestContextTraceContextScope";
            }
        }
        return new RequestContextTraceContextScope(previous);
    }

    private static CurrentTraceContext.Scope createScopeForNonRequestThread(@Nullable TraceContext currentSpan) {
        TraceContext previous = THREAD_LOCAL_CONTEXT.get();
        THREAD_LOCAL_CONTEXT.set(currentSpan);
        class ThreadLocalScope
        implements CurrentTraceContext.Scope {
            final /* synthetic */ TraceContext val$previous;

            ThreadLocalScope(TraceContext traceContext) {
                this.val$previous = traceContext;
            }

            public void close() {
                THREAD_LOCAL_CONTEXT.set(this.val$previous);
            }

            public String toString() {
                return "ThreadLocalScope";
            }
        }
        return new ThreadLocalScope(previous);
    }

    @Nullable
    private static RequestContext getRequestContextOrWarnOnce() {
        return (RequestContext)RequestContext.mapCurrent(Function.identity(), (Supplier)LogRequestContextWarningOnce.INSTANCE);
    }

    @Nullable
    private static Attribute<TraceContext> getTraceContextAttributeOrWarnOnce() {
        RequestContext ctx = RequestContextCurrentTraceContext.getRequestContextOrWarnOnce();
        if (ctx == null) {
            return null;
        }
        return ctx.attr(TRACE_CONTEXT_KEY);
    }

    static {
        INSTANCE = DEFAULT = new RequestContextCurrentTraceContext(new Builder());
        logger = LoggerFactory.getLogger(RequestContextCurrentTraceContext.class);
        TRACE_CONTEXT_KEY = AttributeKey.valueOf(RequestContextCurrentTraceContext.class, (String)"TRACE_CONTEXT");
        THREAD_LOCAL_CONTEXT = new ThreadLocal();
        INCOMPLETE_CONFIGURATION_SCOPE = new CurrentTraceContext.Scope(){

            public void close() {
            }

            public String toString() {
                return "IncompleteConfigurationScope";
            }
        };
        INITIAL_REQUEST_SCOPE = new CurrentTraceContext.Scope(){

            public void close() {
            }

            public String toString() {
                return "InitialRequestScope";
            }
        };
    }

    @VisibleForTesting
    static final class PingPongExtra {
        private boolean pong;

        PingPongExtra() {
        }

        static boolean maybeSetPong(TraceContext context) {
            Object extra;
            if (context.extra().size() == 1 && (extra = context.extra().get(0)) instanceof PingPongExtra) {
                ((PingPongExtra)extra).pong = true;
                return true;
            }
            return false;
        }

        boolean isPong() {
            return this.pong;
        }
    }

    private static enum LogRequestContextWarningOnce implements Supplier<RequestContext>
    {
        INSTANCE;


        @Override
        @Nullable
        public RequestContext get() {
            ClassLoaderHack.loadMe();
            return null;
        }

        private static final class NoRequestContextException
        extends RuntimeException {
            private static final long serialVersionUID = 2804189311774982052L;

            private NoRequestContextException() {
            }
        }

        private static final class ClassLoaderHack {
            private ClassLoaderHack() {
            }

            static void loadMe() {
            }

            static {
                logger.warn("Attempted to propagate trace context, but no request context available. Did you forget to use RequestContext.contextAwareExecutor() or RequestContext.makeContextAware()?", (Throwable)new NoRequestContextException());
            }
        }
    }

    static final class Builder
    extends CurrentTraceContext.Builder {
        public CurrentTraceContext build() {
            return new RequestContextCurrentTraceContext(this);
        }

        Builder() {
        }
    }
}

