/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client.tracing;

import brave.Span;
import brave.Tracer;
import brave.Tracing;
import brave.propagation.Propagation;
import brave.propagation.TraceContext;
import com.linecorp.armeria.client.Client;
import com.linecorp.armeria.client.ClientRequestContext;
import com.linecorp.armeria.client.SimpleDecoratingClient;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.Request;
import com.linecorp.armeria.common.RequestHeaders;
import com.linecorp.armeria.common.RequestHeadersBuilder;
import com.linecorp.armeria.common.logging.RequestLog;
import com.linecorp.armeria.common.logging.RequestLogAvailability;
import com.linecorp.armeria.common.tracing.RequestContextCurrentTraceContext;
import com.linecorp.armeria.internal.tracing.AsciiStringKeyFactory;
import com.linecorp.armeria.internal.tracing.SpanContextUtil;
import com.linecorp.armeria.internal.tracing.SpanTags;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpTracingClient
extends SimpleDecoratingClient<HttpRequest, HttpResponse> {
    private static final Logger logger = LoggerFactory.getLogger(HttpTracingClient.class);
    private final Tracer tracer;
    private final TraceContext.Injector<RequestHeadersBuilder> injector;
    @Nullable
    private final String remoteServiceName;

    public static Function<Client<HttpRequest, HttpResponse>, HttpTracingClient> newDecorator(Tracing tracing) {
        return HttpTracingClient.newDecorator(tracing, null);
    }

    public static Function<Client<HttpRequest, HttpResponse>, HttpTracingClient> newDecorator(Tracing tracing, @Nullable String remoteServiceName) {
        try {
            RequestContextCurrentTraceContext.ensureScopeUsesRequestContext(tracing);
        }
        catch (IllegalStateException e) {
            logger.warn("{} - it is appropriate to ignore this warning if this client is not being used inside an Armeria server (e.g., this is a normal spring-mvc tomcat server).", (Object)e.getMessage());
        }
        return delegate -> new HttpTracingClient((Client<HttpRequest, HttpResponse>)delegate, tracing, remoteServiceName);
    }

    protected HttpTracingClient(Client<HttpRequest, HttpResponse> delegate, Tracing tracing, @Nullable String remoteServiceName) {
        super(delegate);
        this.tracer = tracing.tracer();
        this.injector = tracing.propagationFactory().create((Propagation.KeyFactory)AsciiStringKeyFactory.INSTANCE).injector(RequestHeadersBuilder::set);
        this.remoteServiceName = remoteServiceName;
    }

    public HttpResponse execute(ClientRequestContext ctx, HttpRequest req) throws Exception {
        Span span = this.tracer.nextSpan();
        RequestHeadersBuilder newHeaders = req.headers().toBuilder();
        this.injector.inject(span.context(), (Object)newHeaders);
        req = HttpRequest.of((HttpRequest)req, (RequestHeaders)newHeaders.build());
        ctx.updateRequest((Request)req);
        if (span.isNoop()) {
            return (HttpResponse)this.delegate().execute(ctx, (Request)req);
        }
        String method = ctx.method().name();
        span.kind(Span.Kind.CLIENT).name(method);
        ctx.log().addListener(log -> SpanContextUtil.startSpan(span, log), RequestLogAvailability.REQUEST_START);
        ctx.onChild(RequestContextCurrentTraceContext::copy);
        ctx.log().addListener(log -> {
            SpanTags.logWireSend(span, log.requestFirstBytesTransferredTimeNanos(), log);
            if (log.isAvailable(RequestLogAvailability.RESPONSE_FIRST_BYTES_TRANSFERRED)) {
                SpanTags.logWireReceive(span, log.responseFirstBytesTransferredTimeNanos(), log);
            }
            this.finishSpan(span, log);
        }, RequestLogAvailability.COMPLETE);
        try (Tracer.SpanInScope ignored = this.tracer.withSpanInScope(span);){
            HttpResponse httpResponse = (HttpResponse)this.delegate().execute(ctx, (Request)req);
            return httpResponse;
        }
    }

    private void finishSpan(Span span, RequestLog log) {
        this.setRemoteEndpoint(span, log);
        SpanContextUtil.closeSpan(span, log);
    }

    private void setRemoteEndpoint(Span span, RequestLog log) {
        int port;
        InetAddress address;
        SocketAddress remoteAddress = log.context().remoteAddress();
        if (remoteAddress instanceof InetSocketAddress) {
            InetSocketAddress socketAddress = (InetSocketAddress)remoteAddress;
            address = socketAddress.getAddress();
            port = socketAddress.getPort();
        } else {
            address = null;
            port = 0;
        }
        if (this.remoteServiceName != null) {
            span.remoteServiceName(this.remoteServiceName);
        }
        if (address != null) {
            span.remoteIpAndPort(address.getHostAddress(), port);
        }
    }
}

