/*
 * Decompiled with CFR 0.152.
 */
package com.kfyty.loveqq.framework.web.core.request.support;

import com.kfyty.loveqq.framework.core.lang.util.Mapping;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.nio.charset.StandardCharsets;

public class SseEventStream {
    public static final byte[] LINE_SEPARATOR = "\n".getBytes(StandardCharsets.UTF_8);
    public static final byte[] MESSAGE_SEPARATOR = "\n\n".getBytes(StandardCharsets.UTF_8);
    public static final byte[] EVENT_BYTES = "event:".getBytes(StandardCharsets.UTF_8);
    public static final byte[] ID_BYTES = "id:".getBytes(StandardCharsets.UTF_8);
    public static final byte[] RETRY_BYTES = "retry:".getBytes(StandardCharsets.UTF_8);
    public static final byte[] DATA_BYTES = "data:".getBytes(StandardCharsets.UTF_8);
    private String event;
    private String id;
    private Integer retry;
    private Object data;

    public ByteBuf build() {
        ByteBuf buffer = Unpooled.buffer();
        Mapping.from((Object)this.event).whenNotNull(e -> buffer.writeBytes(EVENT_BYTES).writeBytes(e.getBytes(StandardCharsets.UTF_8)).writeBytes(LINE_SEPARATOR));
        Mapping.from((Object)this.id).whenNotNull(e -> buffer.writeBytes(ID_BYTES).writeBytes(e.getBytes(StandardCharsets.UTF_8)).writeBytes(LINE_SEPARATOR));
        Mapping.from((Object)this.retry).whenNotNull(e -> buffer.writeBytes(RETRY_BYTES).writeBytes(String.valueOf(e).getBytes(StandardCharsets.UTF_8)).writeBytes(LINE_SEPARATOR));
        if (this.data instanceof Number || this.data instanceof Boolean || this.data instanceof CharSequence) {
            return buffer.writeBytes(DATA_BYTES).writeBytes(this.data.toString().getBytes(StandardCharsets.UTF_8)).writeBytes(MESSAGE_SEPARATOR);
        }
        if (this.data instanceof byte[]) {
            return buffer.writeBytes(DATA_BYTES).writeBytes((byte[])this.data).writeBytes(MESSAGE_SEPARATOR);
        }
        throw new IllegalArgumentException("The sse data must be Number/String/byte[]");
    }

    public static SseEventStreamBuilder builder() {
        return new SseEventStreamBuilder();
    }

    public String getEvent() {
        return this.event;
    }

    public String getId() {
        return this.id;
    }

    public Integer getRetry() {
        return this.retry;
    }

    public Object getData() {
        return this.data;
    }

    public void setEvent(String event) {
        this.event = event;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setRetry(Integer retry) {
        this.retry = retry;
    }

    public void setData(Object data) {
        this.data = data;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SseEventStream)) {
            return false;
        }
        SseEventStream other = (SseEventStream)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$retry = this.getRetry();
        Integer other$retry = other.getRetry();
        if (this$retry == null ? other$retry != null : !((Object)this$retry).equals(other$retry)) {
            return false;
        }
        String this$event = this.getEvent();
        String other$event = other.getEvent();
        if (this$event == null ? other$event != null : !this$event.equals(other$event)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        Object this$data = this.getData();
        Object other$data = other.getData();
        return !(this$data == null ? other$data != null : !this$data.equals(other$data));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SseEventStream;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $retry = this.getRetry();
        result = result * 59 + ($retry == null ? 43 : ((Object)$retry).hashCode());
        String $event = this.getEvent();
        result = result * 59 + ($event == null ? 43 : $event.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        Object $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        return result;
    }

    public String toString() {
        return "SseEventStream(event=" + this.getEvent() + ", id=" + this.getId() + ", retry=" + this.getRetry() + ", data=" + this.getData() + ")";
    }

    public SseEventStream() {
    }

    public SseEventStream(String event, String id, Integer retry, Object data) {
        this.event = event;
        this.id = id;
        this.retry = retry;
        this.data = data;
    }

    public static class SseEventStreamBuilder {
        private String event;
        private String id;
        private Integer retry;
        private Object data;

        SseEventStreamBuilder() {
        }

        public SseEventStreamBuilder event(String event) {
            this.event = event;
            return this;
        }

        public SseEventStreamBuilder id(String id) {
            this.id = id;
            return this;
        }

        public SseEventStreamBuilder retry(Integer retry) {
            this.retry = retry;
            return this;
        }

        public SseEventStreamBuilder data(Object data) {
            this.data = data;
            return this;
        }

        public SseEventStream build() {
            return new SseEventStream(this.event, this.id, this.retry, this.data);
        }

        public String toString() {
            return "SseEventStream.SseEventStreamBuilder(event=" + this.event + ", id=" + this.id + ", retry=" + this.retry + ", data=" + this.data + ")";
        }
    }
}

