/*
 * Decompiled with CFR 0.152.
 */
package com.kfyty.loveqq.framework.web.core.request.resolver;

import com.kfyty.loveqq.framework.core.autoconfig.annotation.Component;
import com.kfyty.loveqq.framework.core.autoconfig.annotation.Order;
import com.kfyty.loveqq.framework.core.method.MethodParameter;
import com.kfyty.loveqq.framework.core.support.Instance;
import com.kfyty.loveqq.framework.core.utils.AnnotationUtil;
import com.kfyty.loveqq.framework.core.utils.CommonUtil;
import com.kfyty.loveqq.framework.core.utils.ReflectUtil;
import com.kfyty.loveqq.framework.web.core.annotation.bind.RequestParam;
import com.kfyty.loveqq.framework.web.core.http.ServerRequest;
import com.kfyty.loveqq.framework.web.core.mapping.MethodMapping;
import com.kfyty.loveqq.framework.web.core.request.resolver.AbstractHandlerMethodArgumentResolver;
import com.kfyty.loveqq.framework.web.core.request.resolver.HandlerMethodArgumentResolver;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Component
@Order(value=0x7FFFFFFF)
public class RequestParamMethodArgumentResolver
extends AbstractHandlerMethodArgumentResolver
implements HandlerMethodArgumentResolver {
    @Override
    public boolean supportsParameter(MethodParameter parameter) {
        if (AnnotationUtil.hasAnnotation((Object)parameter.getParameter(), RequestParam.class)) {
            return true;
        }
        String basePackageName = RequestParam.class.getPackage().getName();
        return Arrays.stream(AnnotationUtil.findAnnotations((AnnotatedElement)parameter.getParameter())).noneMatch(e -> e.annotationType().getName().startsWith(basePackageName));
    }

    @Override
    public Object resolveArgument(MethodParameter parameter, MethodMapping mapping, ServerRequest request) {
        RequestParam annotation = (RequestParam)AnnotationUtil.findAnnotation((AnnotatedElement)parameter.getParameter(), RequestParam.class);
        String paramName = parameter.getParameterName((Annotation)annotation, RequestParam::value);
        if (ReflectUtil.isBaseDataType((Class)parameter.getParamType())) {
            String param = request.getParameter(paramName);
            String defaultValue = annotation == null ? "" : annotation.defaultValue();
            return this.createDataBinder(paramName, param != null ? param : defaultValue).getPropertyContext().getProperty(paramName, parameter.getParameterGeneric());
        }
        if (parameter.getParameterGeneric() instanceof Class) {
            String prefix = paramName + '.';
            Map<String, String> parametersMap = request.getParameterMap();
            Map<Boolean, List<Map.Entry>> prefixGroupMap = parametersMap.entrySet().stream().collect(Collectors.groupingBy(k -> ((String)k.getKey()).startsWith(prefix)));
            if (CommonUtil.empty(prefixGroupMap.get(true))) {
                Map<String, String> paramMap = prefixGroupMap.getOrDefault(false, Collections.emptyList()).stream().collect(Collectors.toMap(k -> paramName + '.' + (String)k.getKey(), Map.Entry::getValue));
                return this.createDataBinder(paramMap).bind(new Instance(ReflectUtil.newInstance((Class)parameter.getParamType())), paramName).getTarget();
            }
            Map<String, String> paramMap = prefixGroupMap.get(true).stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            return this.createDataBinder(paramMap).bind(new Instance(ReflectUtil.newInstance((Class)parameter.getParamType())), paramName).getTarget();
        }
        return this.createDataBinder(request.getParameterMap()).getPropertyContext().getProperty(paramName, parameter.getParameterGeneric());
    }
}

