/*
 * Decompiled with CFR 0.152.
 */
package com.kfyty.loveqq.framework.web.core.request.resolver;

import com.kfyty.loveqq.framework.core.autoconfig.annotation.Component;
import com.kfyty.loveqq.framework.core.generic.SimpleGeneric;
import com.kfyty.loveqq.framework.core.method.MethodParameter;
import com.kfyty.loveqq.framework.core.utils.AnnotationUtil;
import com.kfyty.loveqq.framework.core.utils.CommonUtil;
import com.kfyty.loveqq.framework.core.utils.IOUtil;
import com.kfyty.loveqq.framework.core.utils.JsonUtil;
import com.kfyty.loveqq.framework.web.core.annotation.bind.RequestBody;
import com.kfyty.loveqq.framework.web.core.http.ServerRequest;
import com.kfyty.loveqq.framework.web.core.mapping.MethodMapping;
import com.kfyty.loveqq.framework.web.core.request.resolver.HandlerMethodArgumentResolver;
import java.io.InputStream;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Collection;
import java.util.List;

@Component
public class RequestBodyMethodArgumentResolver
implements HandlerMethodArgumentResolver {
    @Override
    public boolean supportsParameter(MethodParameter parameter) {
        return AnnotationUtil.hasAnnotation((Object)parameter.getParameter(), RequestBody.class);
    }

    @Override
    public Object resolveArgument(MethodParameter parameter, MethodMapping mapping, ServerRequest request) {
        if (InputStream.class.isAssignableFrom(parameter.getParamType())) {
            return request.getInputStream();
        }
        if (parameter.getParamType() == byte[].class) {
            return IOUtil.read((InputStream)request.getInputStream());
        }
        if (CharSequence.class.isAssignableFrom(parameter.getParamType())) {
            return IOUtil.toString((InputStream)request.getInputStream());
        }
        String json = IOUtil.toString((InputStream)request.getInputStream());
        SimpleGeneric simpleGeneric = SimpleGeneric.from(parameter.getSource().getClass(), (Parameter)parameter.getParameter());
        if (simpleGeneric.isSimpleGeneric()) {
            if (simpleGeneric.isGeneric(Collection.class)) {
                return JsonUtil.toCollection((CharSequence)json, (Class)simpleGeneric.getRawType(), (Class)simpleGeneric.getSimpleActualType());
            }
            if (simpleGeneric.isSimpleArray()) {
                Collection collection = JsonUtil.toCollection((CharSequence)json, List.class, (Class)simpleGeneric.getSimpleActualType());
                return CommonUtil.copyToArray((Class)simpleGeneric.getSimpleActualType(), (Collection)collection);
            }
            if (simpleGeneric.isMapGeneric()) {
                return JsonUtil.toMap((CharSequence)json, (Class)simpleGeneric.getFirst().get(), (Class)simpleGeneric.getSecond().get());
            }
            if (simpleGeneric.getResolveType() instanceof TypeVariable) {
                return JsonUtil.toObject((CharSequence)json, (Class)simpleGeneric.getSimpleActualType());
            }
        }
        return JsonUtil.toObject((CharSequence)json, (Type)parameter.getParameterGeneric());
    }
}

