/*
 * Decompiled with CFR 0.152.
 */
package com.kfyty.loveqq.framework.web.core.multipart;

import com.kfyty.loveqq.framework.core.lang.Lazy;
import com.kfyty.loveqq.framework.core.utils.IOUtil;
import com.kfyty.loveqq.framework.web.core.multipart.MultipartFile;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class DefaultMultipartFile
implements MultipartFile {
    private final String formName;
    private final String fileName;
    private final String contentType;
    private final boolean isFile;
    private final long size;
    private final Lazy<InputStream> inputStreamLazy;

    @Override
    public boolean isFile() {
        return this.isFile;
    }

    @Override
    public String getName() {
        return this.formName;
    }

    @Override
    public String getOriginalFilename() {
        return this.fileName;
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }

    @Override
    public boolean isEmpty() {
        return this.getSize() < 1L;
    }

    @Override
    public long getSize() {
        return this.size;
    }

    @Override
    public byte[] getBytes() throws IOException {
        try (InputStream in = this.getInputStream();){
            byte[] byArray = IOUtil.read((InputStream)in);
            return byArray;
        }
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return (InputStream)this.inputStreamLazy.get();
    }

    @Override
    public void transferTo(File dest) throws Exception {
        if (dest.exists() && !dest.delete()) {
            throw new IOException("Destination file [" + dest.getAbsolutePath() + "] already exists and could not be deleted !");
        }
        try (InputStream in = this.getInputStream();){
            IOUtil.copy((InputStream)in, (OutputStream)IOUtil.newOutputStream((File)dest));
        }
    }

    @Override
    public void close() throws Exception {
        if (this.inputStreamLazy.isCreated()) {
            IOUtil.close((Object)this.inputStreamLazy.get());
        }
    }

    public DefaultMultipartFile(String formName, String fileName, String contentType, boolean isFile, long size, Lazy<InputStream> inputStreamLazy) {
        this.formName = formName;
        this.fileName = fileName;
        this.contentType = contentType;
        this.isFile = isFile;
        this.size = size;
        this.inputStreamLazy = inputStreamLazy;
    }
}

