/*
 * Decompiled with CFR 0.152.
 */
package com.kfyty.loveqq.framework.web.core.mapping;

import com.kfyty.loveqq.framework.core.utils.CommonUtil;
import com.kfyty.loveqq.framework.web.core.mapping.MethodMapping;
import com.kfyty.loveqq.framework.web.core.request.RequestMethod;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;

public class Routes {
    public static final Pattern SIMPLE_BRACE_PATTERN = Pattern.compile("[{}]");
    public static final Pattern SLASH_PATTERN = Pattern.compile("[/]");
    public static final Pattern BRACE_PATTERN = Pattern.compile("\\{.*}");
    public static final Pattern RESTFUL_URL_PATTERN = Pattern.compile(".*\\{([^/}]*)}.*");
    public static final Routes EMPTY = new Routes(RequestMethod.GET);
    private final RequestMethod requestMethod;
    private final Map<Integer, Map<String, MethodMapping>> indexMapping;

    public Routes(RequestMethod requestMethod) {
        this.requestMethod = requestMethod;
        this.indexMapping = new ConcurrentHashMap<Integer, Map<String, MethodMapping>>();
    }

    public Routes addRoute(MethodMapping methodMapping) {
        if (this.requestMethod != methodMapping.getRequestMethod()) {
            throw new IllegalArgumentException("Route RequestMethod doesn't match");
        }
        Map mappingMap = this.indexMapping.computeIfAbsent(methodMapping.getLength(), k -> new ConcurrentHashMap());
        MethodMapping exists = mappingMap.putIfAbsent(methodMapping.getUrl(), methodMapping);
        if (exists != null) {
            throw new IllegalArgumentException(CommonUtil.format((String)"Route already exists: [RequestMethod: {}, URL:{}] !", (Object[])new Object[]{this.requestMethod, methodMapping.getUrl()}));
        }
        return this;
    }

    public RequestMethod getRequestMethod() {
        return this.requestMethod;
    }

    public Map<Integer, Map<String, MethodMapping>> getIndexMapping() {
        return this.indexMapping;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Routes)) {
            return false;
        }
        Routes other = (Routes)o;
        if (!other.canEqual(this)) {
            return false;
        }
        RequestMethod this$requestMethod = this.getRequestMethod();
        RequestMethod other$requestMethod = other.getRequestMethod();
        if (this$requestMethod == null ? other$requestMethod != null : !((Object)((Object)this$requestMethod)).equals((Object)other$requestMethod)) {
            return false;
        }
        Map<Integer, Map<String, MethodMapping>> this$indexMapping = this.getIndexMapping();
        Map<Integer, Map<String, MethodMapping>> other$indexMapping = other.getIndexMapping();
        return !(this$indexMapping == null ? other$indexMapping != null : !((Object)this$indexMapping).equals(other$indexMapping));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Routes;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        RequestMethod $requestMethod = this.getRequestMethod();
        result = result * 59 + ($requestMethod == null ? 43 : ((Object)((Object)$requestMethod)).hashCode());
        Map<Integer, Map<String, MethodMapping>> $indexMapping = this.getIndexMapping();
        result = result * 59 + ($indexMapping == null ? 43 : ((Object)$indexMapping).hashCode());
        return result;
    }

    public String toString() {
        return "Routes(requestMethod=" + (Object)((Object)this.getRequestMethod()) + ", indexMapping=" + this.getIndexMapping() + ")";
    }
}

