/*
 * Decompiled with CFR 0.152.
 */
package com.kfyty.loveqq.framework.web.core.mapping;

import com.kfyty.loveqq.framework.core.exception.ResolvableException;
import com.kfyty.loveqq.framework.core.lang.Lazy;
import com.kfyty.loveqq.framework.core.method.MethodParameter;
import com.kfyty.loveqq.framework.core.support.Pair;
import com.kfyty.loveqq.framework.core.utils.CommonUtil;
import com.kfyty.loveqq.framework.web.core.mapping.Routes;
import com.kfyty.loveqq.framework.web.core.request.RequestMethod;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MethodMapping
implements Cloneable {
    private static final Logger log = LoggerFactory.getLogger(MethodMapping.class);
    private String url;
    private String[] paths;
    private RequestMethod requestMethod;
    private String produces;
    private boolean restful;
    private Pair<String, Integer>[] restfulMappingIndex;
    private Method mappingMethod;
    private Lazy<Object> controller;

    public Integer getLength() {
        return this.paths.length;
    }

    public boolean isEventStream() {
        return this.produces != null && this.produces.contains("text/event-stream");
    }

    public Object getController() {
        return this.controller.get();
    }

    public Integer getRestfulMappingIndex(String path) {
        if (this.restfulMappingIndex == null) {
            throw new IllegalArgumentException("The restful path index does not exists: restful=" + this.url + ", path=" + path);
        }
        for (Pair<String, Integer> urlMappingIndex : this.restfulMappingIndex) {
            if (!Objects.equals(urlMappingIndex.getKey(), path)) continue;
            return (Integer)urlMappingIndex.getValue();
        }
        throw new IllegalArgumentException("The restful path index does not exists: restful=" + this.url + ", path=" + path);
    }

    public MethodParameter buildMethodParameter(Object[] parameters) {
        return new MethodParameter(this.getController(), this.mappingMethod, parameters);
    }

    public MethodMapping clone() {
        try {
            return (MethodMapping)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new ResolvableException((Throwable)e);
        }
    }

    public static MethodMapping create(String url, RequestMethod requestMethod, Lazy<Object> controller, Method mappingMethod) {
        MethodMapping methodMapping = new MethodMapping();
        methodMapping.setController(controller);
        methodMapping.setMappingMethod(mappingMethod);
        methodMapping.setRequestMethod(requestMethod);
        methodMapping.setUrl(url);
        methodMapping.setPaths(CommonUtil.split((String)url, (String)"[/]").toArray(CommonUtil.EMPTY_STRING_ARRAY));
        MethodMapping.resolveRestfulVariableIfNecessary(methodMapping);
        return methodMapping;
    }

    public static void resolveRestfulVariableIfNecessary(MethodMapping methodMapping) {
        if (!Routes.RESTFUL_URL_PATTERN.matcher(methodMapping.getUrl()).matches()) {
            return;
        }
        String[] paths = methodMapping.getPaths();
        ArrayList<Pair> mappingIndex = new ArrayList<Pair>();
        for (int i = 0; i < paths.length; ++i) {
            if (!CommonUtil.SIMPLE_PARAMETERS_PATTERN.matcher(paths[i]).matches()) continue;
            mappingIndex.add(new Pair((Object)Routes.SIMPLE_BRACE_PATTERN.matcher(paths[i]).replaceAll(""), (Object)i));
        }
        methodMapping.setRestful(true);
        methodMapping.setRestfulMappingIndex(mappingIndex.toArray(new Pair[0]));
    }

    public String getUrl() {
        return this.url;
    }

    public String[] getPaths() {
        return this.paths;
    }

    public RequestMethod getRequestMethod() {
        return this.requestMethod;
    }

    public String getProduces() {
        return this.produces;
    }

    public boolean isRestful() {
        return this.restful;
    }

    public Pair<String, Integer>[] getRestfulMappingIndex() {
        return this.restfulMappingIndex;
    }

    public Method getMappingMethod() {
        return this.mappingMethod;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setPaths(String[] paths) {
        this.paths = paths;
    }

    public void setRequestMethod(RequestMethod requestMethod) {
        this.requestMethod = requestMethod;
    }

    public void setProduces(String produces) {
        this.produces = produces;
    }

    public void setRestful(boolean restful) {
        this.restful = restful;
    }

    public void setRestfulMappingIndex(Pair<String, Integer>[] restfulMappingIndex) {
        this.restfulMappingIndex = restfulMappingIndex;
    }

    public void setMappingMethod(Method mappingMethod) {
        this.mappingMethod = mappingMethod;
    }

    public void setController(Lazy<Object> controller) {
        this.controller = controller;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MethodMapping)) {
            return false;
        }
        MethodMapping other = (MethodMapping)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isRestful() != other.isRestful()) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getPaths(), other.getPaths())) {
            return false;
        }
        RequestMethod this$requestMethod = this.getRequestMethod();
        RequestMethod other$requestMethod = other.getRequestMethod();
        if (this$requestMethod == null ? other$requestMethod != null : !((Object)((Object)this$requestMethod)).equals((Object)other$requestMethod)) {
            return false;
        }
        String this$produces = this.getProduces();
        String other$produces = other.getProduces();
        if (this$produces == null ? other$produces != null : !this$produces.equals(other$produces)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getRestfulMappingIndex(), other.getRestfulMappingIndex())) {
            return false;
        }
        Method this$mappingMethod = this.getMappingMethod();
        Method other$mappingMethod = other.getMappingMethod();
        if (this$mappingMethod == null ? other$mappingMethod != null : !((Object)this$mappingMethod).equals(other$mappingMethod)) {
            return false;
        }
        Object this$controller = this.getController();
        Object other$controller = other.getController();
        return !(this$controller == null ? other$controller != null : !this$controller.equals(other$controller));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MethodMapping;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isRestful() ? 79 : 97);
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getPaths());
        RequestMethod $requestMethod = this.getRequestMethod();
        result = result * 59 + ($requestMethod == null ? 43 : ((Object)((Object)$requestMethod)).hashCode());
        String $produces = this.getProduces();
        result = result * 59 + ($produces == null ? 43 : $produces.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getRestfulMappingIndex());
        Method $mappingMethod = this.getMappingMethod();
        result = result * 59 + ($mappingMethod == null ? 43 : ((Object)$mappingMethod).hashCode());
        Object $controller = this.getController();
        result = result * 59 + ($controller == null ? 43 : $controller.hashCode());
        return result;
    }

    public String toString() {
        return "MethodMapping(url=" + this.getUrl() + ", paths=" + Arrays.deepToString(this.getPaths()) + ", requestMethod=" + (Object)((Object)this.getRequestMethod()) + ", produces=" + this.getProduces() + ", restful=" + this.isRestful() + ", restfulMappingIndex=" + Arrays.deepToString(this.getRestfulMappingIndex()) + ", mappingMethod=" + this.getMappingMethod() + ", controller=" + this.getController() + ")";
    }
}

