/*
 * Decompiled with CFR 0.152.
 */
package com.kfyty.loveqq.framework.web.core.handler;

import com.kfyty.loveqq.framework.core.lang.Lazy;
import com.kfyty.loveqq.framework.core.utils.AnnotationUtil;
import com.kfyty.loveqq.framework.core.utils.CommonUtil;
import com.kfyty.loveqq.framework.core.utils.ReflectUtil;
import com.kfyty.loveqq.framework.web.core.annotation.RequestMapping;
import com.kfyty.loveqq.framework.web.core.annotation.bind.ResponseBody;
import com.kfyty.loveqq.framework.web.core.handler.RequestMappingHandler;
import com.kfyty.loveqq.framework.web.core.mapping.MethodMapping;
import com.kfyty.loveqq.framework.web.core.request.RequestMethod;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestMappingAnnotationHandler
implements RequestMappingHandler {
    private static final Logger log = LoggerFactory.getLogger(RequestMappingAnnotationHandler.class);

    @Override
    public List<MethodMapping> resolveRequestMapping(Class<?> controllerClass, Lazy<Object> controller) {
        String superUrl = "";
        ArrayList<MethodMapping> retValue = new ArrayList<MethodMapping>();
        RequestMapping annotation = (RequestMapping)AnnotationUtil.findAnnotation(controllerClass, RequestMapping.class);
        if (annotation != null) {
            superUrl = CommonUtil.formatURI((String)annotation.value());
        }
        this.resolveMethodMapping(annotation, superUrl, controllerClass, controller, retValue);
        return retValue;
    }

    protected void resolveMethodMapping(RequestMapping superAnnotation, String superUrl, Class<?> controllerClass, Lazy<Object> controller, List<MethodMapping> methodMappings) {
        Method[] methods;
        boolean expose = superAnnotation != null && superAnnotation.expose();
        for (Method method : methods = ReflectUtil.getMethods(controllerClass)) {
            if (Modifier.isStatic(method.getModifiers()) || method.getDeclaringClass() == Object.class) continue;
            RequestMapping annotation = (RequestMapping)AnnotationUtil.findAnnotation((AnnotatedElement)method, RequestMapping.class);
            if (annotation == null && expose) {
                if (!Modifier.isPublic(method.getModifiers())) continue;
                annotation = superAnnotation;
            }
            if (annotation == null) continue;
            RequestMethod requestMethod = annotation == superAnnotation ? RequestMethod.POST : annotation.method();
            String requestURI = annotation == superAnnotation || CommonUtil.empty((Object)annotation.value()) && annotation.strategy() == RequestMapping.Strategy.DEFAULT ? method.getName() : annotation.value();
            String mappingPath = superUrl + CommonUtil.formatURI((String)requestURI);
            MethodMapping methodMapping = MethodMapping.create(mappingPath, requestMethod, controller, method);
            methodMappings.add(this.resolveRequestMappingProduces(controllerClass, annotation, methodMapping));
        }
    }

    protected MethodMapping resolveRequestMappingProduces(Class<?> controllerClass, RequestMapping annotation, MethodMapping methodMapping) {
        methodMapping.setProduces(annotation.produces());
        if (!methodMapping.isEventStream()) {
            ResponseBody responseBody = (ResponseBody)AnnotationUtil.findAnnotation((AnnotatedElement)methodMapping.getMappingMethod(), ResponseBody.class);
            if (responseBody == null && "text/plain; charset=utf-8".equals(annotation.produces())) {
                responseBody = (ResponseBody)AnnotationUtil.findAnnotation(controllerClass, ResponseBody.class);
            }
            if (responseBody != null) {
                methodMapping.setProduces(responseBody.contentType());
            }
        }
        log.info("Resolved request mapping: [URI:{}, RequestMethod:{}, MappingMethod:{}]", new Object[]{methodMapping.getUrl(), methodMapping.getRequestMethod(), methodMapping.getMappingMethod()});
        return methodMapping;
    }
}

