/*
 * Decompiled with CFR 0.152.
 */
package com.kfyty.loveqq.framework.web.core.handler;

import com.kfyty.loveqq.framework.core.lang.Lazy;
import com.kfyty.loveqq.framework.core.lang.function.SerializableBiConsumer;
import com.kfyty.loveqq.framework.core.lang.function.SerializableBiFunction;
import com.kfyty.loveqq.framework.core.support.AntPathMatcher;
import com.kfyty.loveqq.framework.core.support.Pair;
import com.kfyty.loveqq.framework.core.support.PatternMatcher;
import com.kfyty.loveqq.framework.core.utils.CommonUtil;
import com.kfyty.loveqq.framework.core.utils.SerializableLambdaUtil;
import com.kfyty.loveqq.framework.web.core.handler.RequestMappingMatcher;
import com.kfyty.loveqq.framework.web.core.http.ServerRequest;
import com.kfyty.loveqq.framework.web.core.http.ServerResponse;
import com.kfyty.loveqq.framework.web.core.mapping.MethodMapping;
import com.kfyty.loveqq.framework.web.core.mapping.Routes;
import com.kfyty.loveqq.framework.web.core.request.RequestMethod;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

public class DefaultRequestMappingMatcher
implements RequestMappingMatcher {
    private final PatternMatcher patternMatcher;
    private final Map<RequestMethod, Routes> routesMap;

    public DefaultRequestMappingMatcher() {
        this((PatternMatcher)new AntPathMatcher(), new ConcurrentHashMap<RequestMethod, Routes>((int)((double)RequestMethod.values().length / 0.075 + 1.0)));
    }

    @Override
    public MethodMapping registryRoute(String url, RequestMethod requestMethod, SerializableBiConsumer<ServerRequest, ServerResponse> route) {
        Pair pair = SerializableLambdaUtil.resolveMethod(route, (Class[])new Class[]{ServerRequest.class, ServerResponse.class});
        if (pair.getValue() == null) {
            throw new IllegalArgumentException("Registry route failed, resolve method from lambda failed: " + url);
        }
        return this.registryMethodMapping(url, requestMethod, pair.getKey(), (Method)pair.getValue());
    }

    @Override
    public MethodMapping registryRoute(String url, RequestMethod requestMethod, SerializableBiFunction<ServerRequest, ServerResponse, Object> route) {
        Pair pair = SerializableLambdaUtil.resolveMethod(route, (Class[])new Class[]{ServerRequest.class, ServerResponse.class});
        if (pair.getValue() == null) {
            throw new IllegalArgumentException("Registry route failed, resolve method from lambda failed: " + url);
        }
        return this.registryMethodMapping(url, requestMethod, pair.getKey(), (Method)pair.getValue());
    }

    @Override
    public MethodMapping registryMethodMapping(String url, RequestMethod requestMethod, Object controller, Method mappingMethod) {
        MethodMapping methodMapping = MethodMapping.create(url, requestMethod, (Lazy<Object>)new Lazy(() -> controller), mappingMethod);
        this.registryMethodMapping(methodMapping);
        return methodMapping;
    }

    @Override
    public void registryMethodMapping(MethodMapping mapping) {
        Routes routes = this.routesMap.computeIfAbsent(mapping.getRequestMethod(), Routes::new);
        routes.addRoute(mapping);
    }

    @Override
    public void registryMethodMapping(List<MethodMapping> methodMappings) {
        if (CommonUtil.empty(methodMappings)) {
            return;
        }
        for (MethodMapping methodMapping : methodMappings) {
            Routes routes = this.routesMap.computeIfAbsent(methodMapping.getRequestMethod(), Routes::new);
            routes.addRoute(methodMapping);
        }
    }

    @Override
    public Routes getRoutes(RequestMethod requestMethod) {
        return this.routesMap.getOrDefault((Object)requestMethod, Routes.EMPTY);
    }

    @Override
    public List<MethodMapping> getRoutes() {
        return this.routesMap.values().stream().flatMap(e -> e.getIndexMapping().values().stream().flatMap(p -> p.values().stream())).collect(Collectors.toList());
    }

    @Override
    public MethodMapping matchRoute(RequestMethod method, String requestURI) {
        MethodMapping methodMapping = this.preciseMatch(method, requestURI);
        if (methodMapping != null) {
            return methodMapping;
        }
        return this.antPathMatch(method, requestURI);
    }

    protected MethodMapping preciseMatch(RequestMethod method, String requestURI) {
        String[] paths = Routes.SLASH_PATTERN.split(requestURI, 0);
        Map<String, MethodMapping> mappingMap = this.getRoutes(method).getIndexMapping().get(paths.length);
        if (CommonUtil.empty(mappingMap)) {
            return null;
        }
        MethodMapping methodMapping = mappingMap.get(requestURI);
        return methodMapping != null ? methodMapping : this.restfulMatch(method, requestURI, paths, mappingMap);
    }

    protected MethodMapping antPathMatch(RequestMethod method, String requestURI) {
        Routes routes = this.getRoutes(method);
        for (Map<String, MethodMapping> mappingMap : routes.getIndexMapping().values()) {
            for (Map.Entry<String, MethodMapping> entry : mappingMap.entrySet()) {
                String pattern = entry.getValue().isRestful() ? Routes.BRACE_PATTERN.matcher(entry.getKey()).replaceAll("*") : entry.getKey();
                if (!this.patternMatcher.matches(pattern, requestURI)) continue;
                return entry.getValue();
            }
        }
        return null;
    }

    protected MethodMapping restfulMatch(RequestMethod method, String requestURI, String[] paths, Map<String, MethodMapping> mappingMap) {
        ArrayList<MethodMapping> methodMappings = new ArrayList<MethodMapping>();
        for (MethodMapping methodMapping : mappingMap.values()) {
            if (!methodMapping.isRestful()) continue;
            boolean match = true;
            int length = paths.length;
            for (int i = 0; i < length; ++i) {
                if (CommonUtil.SIMPLE_PARAMETERS_PATTERN.matcher(methodMapping.getPaths()[i]).matches() || methodMapping.getPaths()[i].equals(paths[i])) continue;
                match = false;
                break;
            }
            if (!match) continue;
            methodMappings.add(methodMapping);
        }
        return this.matchBestRestful(method, requestURI, methodMappings);
    }

    protected MethodMapping matchBestRestful(RequestMethod method, String requestURI, List<MethodMapping> methodMappings) {
        if (CommonUtil.empty(methodMappings)) {
            return null;
        }
        if (methodMappings.size() == 1) {
            return methodMappings.get(0);
        }
        if ((methodMappings = methodMappings.stream().sorted(Comparator.comparingInt(e -> e.getRestfulMappingIndex().length)).collect(Collectors.toList())).get(0).getRestfulMappingIndex().length == methodMappings.get(1).getRestfulMappingIndex().length) {
            throw new IllegalArgumentException(CommonUtil.format((String)"Request mapping method ambiguous: [RequestMethod: {}, URI:{}] !", (Object[])new Object[]{method, requestURI}));
        }
        return methodMappings.get(0);
    }

    public DefaultRequestMappingMatcher(PatternMatcher patternMatcher, Map<RequestMethod, Routes> routesMap) {
        this.patternMatcher = patternMatcher;
        this.routesMap = routesMap;
    }
}

