/*
 * Decompiled with CFR 0.152.
 */
package com.kfyty.loveqq.framework.web.core.handler;

import com.kfyty.loveqq.framework.core.autoconfig.InitializingBean;
import com.kfyty.loveqq.framework.core.lang.Lazy;
import com.kfyty.loveqq.framework.core.method.MethodParameter;
import com.kfyty.loveqq.framework.core.support.Pair;
import com.kfyty.loveqq.framework.core.support.PatternMatcher;
import com.kfyty.loveqq.framework.core.utils.AnnotationUtil;
import com.kfyty.loveqq.framework.core.utils.AopUtil;
import com.kfyty.loveqq.framework.core.utils.CommonUtil;
import com.kfyty.loveqq.framework.core.utils.ExceptionUtil;
import com.kfyty.loveqq.framework.core.utils.ReflectUtil;
import com.kfyty.loveqq.framework.web.core.annotation.ControllerAdvice;
import com.kfyty.loveqq.framework.web.core.annotation.bind.ResponseBody;
import com.kfyty.loveqq.framework.web.core.handler.ExceptionHandler;
import com.kfyty.loveqq.framework.web.core.http.ServerRequest;
import com.kfyty.loveqq.framework.web.core.http.ServerResponse;
import com.kfyty.loveqq.framework.web.core.mapping.MethodMapping;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.LinkedHashMap;
import java.util.Map;

public class AnnotatedExceptionHandler
implements ExceptionHandler,
InitializingBean {
    private final PatternMatcher patternMatcher;
    private final String[] controllerAdviceBasePackages;
    private final Class<? extends Annotation>[] controllerAdviceAnnotations;
    private final Lazy<Object> adviceBean;
    private Map<Class<? extends Throwable>, MethodParameter> exceptionHandlerMap;

    public void afterPropertiesSet() {
        Object target = this.adviceBean.get();
        Class targetClass = AopUtil.getTargetClass((Object)target);
        this.exceptionHandlerMap = new LinkedHashMap<Class<? extends Throwable>, MethodParameter>();
        for (Method method : ReflectUtil.getMethods((Class)targetClass)) {
            Class<Throwable>[] exceptionClasses;
            com.kfyty.loveqq.framework.web.core.annotation.ExceptionHandler annotation = (com.kfyty.loveqq.framework.web.core.annotation.ExceptionHandler)AnnotationUtil.findAnnotation((AnnotatedElement)method, com.kfyty.loveqq.framework.web.core.annotation.ExceptionHandler.class);
            if (annotation == null) continue;
            for (Class<Throwable> exceptionClass : exceptionClasses = CommonUtil.notEmpty(annotation.value()) ? annotation.value() : method.getParameterTypes()) {
                if (!Throwable.class.isAssignableFrom(exceptionClass)) continue;
                Method targetMethod = AopUtil.getInterfaceMethod((Class)targetClass, (Method)method);
                MethodParameter methodParameter = new MethodParameter(target, targetMethod);
                this.exceptionHandlerMap.put(exceptionClass, methodParameter.metadata((Object)this.obtainContentType(methodParameter)));
            }
        }
    }

    @Override
    public boolean canHandle(MethodMapping mapping, Throwable throwable) {
        Object controller = mapping.getController();
        if (controller == null) {
            return false;
        }
        Object target = AopUtil.getTarget((Object)controller);
        String targetClassName = target.getClass().getName();
        for (String basePackage : this.controllerAdviceBasePackages) {
            if (!this.patternMatcher.matches(basePackage, targetClassName)) continue;
            return true;
        }
        return AnnotationUtil.hasAnyAnnotation(target.getClass(), (Class[])this.controllerAdviceAnnotations);
    }

    @Override
    public Pair<MethodParameter, Object> handle(ServerRequest request, ServerResponse response, MethodMapping mapping, Throwable throwable) throws Throwable {
        MethodParameter adviceMethod = this.findControllerExceptionAdvice(request, response, mapping, ExceptionUtil.unwrap((Throwable)throwable));
        if (adviceMethod == null) {
            throw throwable;
        }
        return new Pair((Object)adviceMethod, ReflectUtil.invokeMethod((Object)adviceMethod.getSource(), (Method)adviceMethod.getMethod(), (Object[])adviceMethod.getMethodArgs()));
    }

    public MethodParameter findControllerExceptionAdvice(ServerRequest request, ServerResponse response, MethodMapping mapping, Throwable throwable) {
        Class<?> throwableClass = throwable.getClass();
        MethodParameter exceptionHandler = this.exceptionHandlerMap.get(throwableClass);
        if (exceptionHandler == null) {
            exceptionHandler = this.exceptionHandlerMap.entrySet().stream().filter(e -> ((Class)e.getKey()).isAssignableFrom(throwableClass)).findFirst().map(Map.Entry::getValue).orElse(null);
        }
        if (exceptionHandler == null) {
            return null;
        }
        Parameter[] parameters = exceptionHandler.getMethod().getParameters();
        Object[] exceptionArgs = new Object[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            Class<?> parameterType = parameters[i].getType();
            if (ServerRequest.class.isAssignableFrom(parameterType)) {
                exceptionArgs[i] = request;
                continue;
            }
            if (ServerResponse.class.isAssignableFrom(parameterType)) {
                exceptionArgs[i] = response;
                continue;
            }
            if (MethodMapping.class.isAssignableFrom(parameterType)) {
                exceptionArgs[i] = mapping;
                continue;
            }
            if (!parameterType.isAssignableFrom(throwableClass)) continue;
            exceptionArgs[i] = throwable;
        }
        MethodMapping cloned = mapping.clone();
        MethodParameter handler = exceptionHandler.clone();
        handler.setMethodArgs(exceptionArgs);
        if (handler.getMetadata() != null) {
            cloned.setProduces(handler.getMetadata().toString());
        }
        return handler.metadata((Object)cloned);
    }

    protected String obtainContentType(MethodParameter exceptionHandler) {
        String contentType = null;
        ControllerAdvice controllerAdvice = (ControllerAdvice)AnnotationUtil.findAnnotation((Object)exceptionHandler.getSource(), ControllerAdvice.class);
        if (controllerAdvice != null) {
            contentType = controllerAdvice.produces();
        }
        if (controllerAdvice == null || "text/plain; charset=utf-8".equals(controllerAdvice.produces())) {
            ResponseBody annotation = (ResponseBody)AnnotationUtil.findAnnotation((AnnotatedElement)exceptionHandler.getMethod(), ResponseBody.class);
            if (annotation == null) {
                annotation = (ResponseBody)AnnotationUtil.findAnnotation((Object)exceptionHandler.getSource(), ResponseBody.class);
            }
            if (annotation != null) {
                contentType = annotation.contentType();
            }
        }
        return contentType;
    }

    public AnnotatedExceptionHandler(PatternMatcher patternMatcher, String[] controllerAdviceBasePackages, Class<? extends Annotation>[] controllerAdviceAnnotations, Lazy<Object> adviceBean) {
        this.patternMatcher = patternMatcher;
        this.controllerAdviceBasePackages = controllerAdviceBasePackages;
        this.controllerAdviceAnnotations = controllerAdviceAnnotations;
        this.adviceBean = adviceBean;
    }
}

