/*
 * Decompiled with CFR 0.152.
 */
package com.kfyty.loveqq.framework.web.core.filter.reactor;

import com.kfyty.loveqq.framework.core.support.AntPathMatcher;
import com.kfyty.loveqq.framework.core.support.PatternMatcher;
import com.kfyty.loveqq.framework.web.core.filter.Filter;
import com.kfyty.loveqq.framework.web.core.filter.FilterChain;
import com.kfyty.loveqq.framework.web.core.filter.ws.WsFilter;
import com.kfyty.loveqq.framework.web.core.http.ServerRequest;
import com.kfyty.loveqq.framework.web.core.http.ServerResponse;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public class DefaultFilterChain
implements FilterChain {
    private int index = 0;
    private final PatternMatcher matcher;
    private final List<Filter> filters;
    private final Supplier<Publisher<Void>> handler;

    public DefaultFilterChain(List<Filter> filters, Supplier<Publisher<Void>> handler) {
        this((PatternMatcher)new AntPathMatcher(), filters, handler);
    }

    public DefaultFilterChain(PatternMatcher patternMatcher, List<Filter> filters, Supplier<Publisher<Void>> handler) {
        this.matcher = patternMatcher;
        this.filters = filters;
        this.handler = Objects.requireNonNull(handler);
    }

    @Override
    public Publisher<Void> doFilter(ServerRequest request, ServerResponse response) {
        Filter filter;
        if (this.filters == null || this.index >= this.filters.size()) {
            return Mono.defer(() -> Mono.from(this.handler.get()));
        }
        if ((filter = this.filters.get(this.index++)) instanceof WsFilter ? !filter.isWebSocket(request) : filter.isWebSocket(request)) {
            return this.doFilter(request, response);
        }
        String requestUri = request.getRequestURI();
        boolean anyMatch = Arrays.stream(filter.getPattern()).anyMatch(pattern -> this.matcher.matches(pattern, requestUri));
        if (anyMatch) {
            return filter.doFilter(request, response, this);
        }
        return this.doFilter(request, response);
    }
}

