/*
 * Decompiled with CFR 0.152.
 */
package com.kfyty.loveqq.framework.web.core.filter;

import com.kfyty.loveqq.framework.core.utils.IOC;
import com.kfyty.loveqq.framework.web.core.filter.FilterChain;
import com.kfyty.loveqq.framework.web.core.filter.internal.FilterTransformer;
import com.kfyty.loveqq.framework.web.core.http.ServerRequest;
import com.kfyty.loveqq.framework.web.core.http.ServerResponse;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public interface Filter {
    default public String[] getPattern() {
        if (IOC.isServletWeb()) {
            return new String[]{"/*"};
        }
        return new String[]{"/**"};
    }

    default public boolean isWebSocket(ServerRequest request) {
        String connection = request.getHeader("connection");
        return connection != null && connection.equalsIgnoreCase("upgrade");
    }

    default public Publisher<Void> doFilter(ServerRequest request, ServerResponse response, FilterChain chain) {
        return Mono.fromSupplier(() -> this.doFilter(request, response)).flatMap((Function)new FilterTransformer(request, response, chain));
    }

    default public Continue doFilter(ServerRequest request, ServerResponse response) {
        return Continue.TRUE;
    }

    public static class Continue {
        public static final Continue TRUE = Continue.ofTrue();
        public static final Continue FALSE = Continue.ofFalse();
        private final boolean _continue_;
        private final Runnable _finally_;

        public boolean _continue_() {
            return this._continue_;
        }

        public void finally_run() {
            if (this._finally_ != null) {
                this._finally_.run();
            }
        }

        public static Continue ofTrue() {
            return new Continue(true, null);
        }

        public static Continue ofTrue(Runnable _finally_) {
            return new Continue(true, _finally_);
        }

        public static Continue ofFalse() {
            return new Continue(false, null);
        }

        public static Continue ofFalse(Runnable _finally_) {
            return new Continue(false, _finally_);
        }

        public Continue(boolean _continue_, Runnable _finally_) {
            this._continue_ = _continue_;
            this._finally_ = _finally_;
        }
    }
}

