/*
 * Decompiled with CFR 0.152.
 */
package com.kfyty.loveqq.framework.web.core.cors;

import com.kfyty.loveqq.framework.core.support.AntPathMatcher;
import com.kfyty.loveqq.framework.core.support.PatternMatcher;
import com.kfyty.loveqq.framework.web.core.http.ServerRequest;
import com.kfyty.loveqq.framework.web.core.http.ServerResponse;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;

public class CorsConfiguration {
    private PatternMatcher patternMatcher;
    private List<String> patternPaths = Collections.emptyList();
    private List<String> allowOrigin = Collections.emptyList();
    private List<String> allowedMethods = Collections.emptyList();
    private List<String> allowedHeaders = Collections.emptyList();
    private List<String> exposeHeaders = Collections.emptyList();
    private Boolean allowCredentials;
    private Integer maxAge;

    public CorsConfiguration addPatternPath(String ... paths) {
        if (this.patternPaths == Collections.emptyList()) {
            this.patternPaths = new LinkedList<String>();
        }
        this.patternPaths.addAll(Arrays.asList(paths));
        return this;
    }

    public CorsConfiguration addAllowedOrigins(String ... origins) {
        if (this.allowOrigin == Collections.emptyList()) {
            this.allowOrigin = new LinkedList<String>();
        }
        this.allowOrigin.addAll(Arrays.asList(origins));
        return this;
    }

    public CorsConfiguration addAllowedMethods(String ... methods) {
        if (this.allowedMethods == Collections.emptyList()) {
            this.allowedMethods = new LinkedList<String>();
        }
        this.allowedMethods.addAll(Arrays.asList(methods));
        return this;
    }

    public CorsConfiguration addAllowedHeaders(String ... headers) {
        if (this.allowedHeaders == Collections.emptyList()) {
            this.allowedHeaders = new LinkedList<String>();
        }
        this.allowedHeaders.addAll(Arrays.asList(headers));
        return this;
    }

    public CorsConfiguration addExposeHeaders(String ... headers) {
        if (this.exposeHeaders == Collections.emptyList()) {
            this.exposeHeaders = new LinkedList<String>();
        }
        this.exposeHeaders.addAll(Arrays.asList(headers));
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PatternMatcher getPatternMatcher() {
        if (this.patternMatcher == null) {
            CorsConfiguration corsConfiguration = this;
            synchronized (corsConfiguration) {
                if (this.patternMatcher == null) {
                    this.patternMatcher = new AntPathMatcher();
                }
            }
        }
        return this.patternMatcher;
    }

    public boolean shouldApplyCors(String requestUri) {
        if (this.patternPaths.isEmpty()) {
            return true;
        }
        PatternMatcher patternMatcher = this.getPatternMatcher();
        for (String patternPath : this.patternPaths) {
            if (!patternMatcher.matches(patternPath, requestUri)) continue;
            return true;
        }
        return false;
    }

    public void apply(ServerRequest request, ServerResponse response) {
        if (!this.shouldApplyCors(request.getRequestURI())) {
            return;
        }
        Optional<String> optionalOrigin = Optional.of("*");
        if (!this.allowOrigin.contains("*")) {
            String requestOrigin = request.getHeader("Origin");
            optionalOrigin = this.allowOrigin.stream().filter(e -> e.equals(requestOrigin)).findAny();
            if (!optionalOrigin.isPresent()) {
                return;
            }
        }
        response.addHeader("Access-Control-Allow-Origin", optionalOrigin.get());
        response.addHeader("Access-Control-Allow-Methods", String.join((CharSequence)",", this.allowedMethods));
        response.addHeader("Access-Control-Allow-Headers", String.join((CharSequence)",", this.allowedHeaders));
        response.addHeader("Access-Control-Expose-Headers", String.join((CharSequence)",", this.exposeHeaders));
        if (this.allowCredentials != null && this.allowCredentials.booleanValue()) {
            response.addHeader("Access-Control-Allow-Credentials", Boolean.TRUE.toString());
        }
        if (this.maxAge != null) {
            response.addHeader("Access-Control-Max-Age", Integer.toString(this.maxAge));
        }
    }

    public List<String> getPatternPaths() {
        return this.patternPaths;
    }

    public List<String> getAllowOrigin() {
        return this.allowOrigin;
    }

    public List<String> getAllowedMethods() {
        return this.allowedMethods;
    }

    public List<String> getAllowedHeaders() {
        return this.allowedHeaders;
    }

    public List<String> getExposeHeaders() {
        return this.exposeHeaders;
    }

    public Boolean getAllowCredentials() {
        return this.allowCredentials;
    }

    public Integer getMaxAge() {
        return this.maxAge;
    }

    public void setPatternMatcher(PatternMatcher patternMatcher) {
        this.patternMatcher = patternMatcher;
    }

    public void setPatternPaths(List<String> patternPaths) {
        this.patternPaths = patternPaths;
    }

    public void setAllowOrigin(List<String> allowOrigin) {
        this.allowOrigin = allowOrigin;
    }

    public void setAllowedMethods(List<String> allowedMethods) {
        this.allowedMethods = allowedMethods;
    }

    public void setAllowedHeaders(List<String> allowedHeaders) {
        this.allowedHeaders = allowedHeaders;
    }

    public void setExposeHeaders(List<String> exposeHeaders) {
        this.exposeHeaders = exposeHeaders;
    }

    public void setAllowCredentials(Boolean allowCredentials) {
        this.allowCredentials = allowCredentials;
    }

    public void setMaxAge(Integer maxAge) {
        this.maxAge = maxAge;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CorsConfiguration)) {
            return false;
        }
        CorsConfiguration other = (CorsConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$allowCredentials = this.getAllowCredentials();
        Boolean other$allowCredentials = other.getAllowCredentials();
        if (this$allowCredentials == null ? other$allowCredentials != null : !((Object)this$allowCredentials).equals(other$allowCredentials)) {
            return false;
        }
        Integer this$maxAge = this.getMaxAge();
        Integer other$maxAge = other.getMaxAge();
        if (this$maxAge == null ? other$maxAge != null : !((Object)this$maxAge).equals(other$maxAge)) {
            return false;
        }
        PatternMatcher this$patternMatcher = this.getPatternMatcher();
        PatternMatcher other$patternMatcher = other.getPatternMatcher();
        if (this$patternMatcher == null ? other$patternMatcher != null : !this$patternMatcher.equals(other$patternMatcher)) {
            return false;
        }
        List<String> this$patternPaths = this.getPatternPaths();
        List<String> other$patternPaths = other.getPatternPaths();
        if (this$patternPaths == null ? other$patternPaths != null : !((Object)this$patternPaths).equals(other$patternPaths)) {
            return false;
        }
        List<String> this$allowOrigin = this.getAllowOrigin();
        List<String> other$allowOrigin = other.getAllowOrigin();
        if (this$allowOrigin == null ? other$allowOrigin != null : !((Object)this$allowOrigin).equals(other$allowOrigin)) {
            return false;
        }
        List<String> this$allowedMethods = this.getAllowedMethods();
        List<String> other$allowedMethods = other.getAllowedMethods();
        if (this$allowedMethods == null ? other$allowedMethods != null : !((Object)this$allowedMethods).equals(other$allowedMethods)) {
            return false;
        }
        List<String> this$allowedHeaders = this.getAllowedHeaders();
        List<String> other$allowedHeaders = other.getAllowedHeaders();
        if (this$allowedHeaders == null ? other$allowedHeaders != null : !((Object)this$allowedHeaders).equals(other$allowedHeaders)) {
            return false;
        }
        List<String> this$exposeHeaders = this.getExposeHeaders();
        List<String> other$exposeHeaders = other.getExposeHeaders();
        return !(this$exposeHeaders == null ? other$exposeHeaders != null : !((Object)this$exposeHeaders).equals(other$exposeHeaders));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CorsConfiguration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $allowCredentials = this.getAllowCredentials();
        result = result * 59 + ($allowCredentials == null ? 43 : ((Object)$allowCredentials).hashCode());
        Integer $maxAge = this.getMaxAge();
        result = result * 59 + ($maxAge == null ? 43 : ((Object)$maxAge).hashCode());
        PatternMatcher $patternMatcher = this.getPatternMatcher();
        result = result * 59 + ($patternMatcher == null ? 43 : $patternMatcher.hashCode());
        List<String> $patternPaths = this.getPatternPaths();
        result = result * 59 + ($patternPaths == null ? 43 : ((Object)$patternPaths).hashCode());
        List<String> $allowOrigin = this.getAllowOrigin();
        result = result * 59 + ($allowOrigin == null ? 43 : ((Object)$allowOrigin).hashCode());
        List<String> $allowedMethods = this.getAllowedMethods();
        result = result * 59 + ($allowedMethods == null ? 43 : ((Object)$allowedMethods).hashCode());
        List<String> $allowedHeaders = this.getAllowedHeaders();
        result = result * 59 + ($allowedHeaders == null ? 43 : ((Object)$allowedHeaders).hashCode());
        List<String> $exposeHeaders = this.getExposeHeaders();
        result = result * 59 + ($exposeHeaders == null ? 43 : ((Object)$exposeHeaders).hashCode());
        return result;
    }

    public String toString() {
        return "CorsConfiguration(patternMatcher=" + this.getPatternMatcher() + ", patternPaths=" + this.getPatternPaths() + ", allowOrigin=" + this.getAllowOrigin() + ", allowedMethods=" + this.getAllowedMethods() + ", allowedHeaders=" + this.getAllowedHeaders() + ", exposeHeaders=" + this.getExposeHeaders() + ", allowCredentials=" + this.getAllowCredentials() + ", maxAge=" + this.getMaxAge() + ")";
    }
}

