/*
 * Decompiled with CFR 0.152.
 */
package com.kfyty.loveqq.framework.web.core.autoconfig;

import com.kfyty.loveqq.framework.core.autoconfig.annotation.Component;
import com.kfyty.loveqq.framework.core.autoconfig.annotation.ConfigurationProperties;
import com.kfyty.loveqq.framework.core.support.Pair;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@ConfigurationProperties(value="k.server")
public class WebServerProperties {
    private static final Logger log = LoggerFactory.getLogger(WebServerProperties.class);
    public static final String DEFAULT_DISPATCHER_MAPPING = "/";
    protected boolean virtualThread = true;
    protected Integer maxThreads;
    protected int port = 8080;
    protected String location;
    protected Long maxFileSize;
    protected List<String> staticPattern;
    protected List<Pair<String, String>> resources;
    protected Class<?> primarySource;

    public WebServerProperties() {
        this(WebServerProperties.class);
    }

    public WebServerProperties(Class<?> primarySource) {
        this.primarySource = primarySource;
        this.staticPattern = new LinkedList<String>();
        this.resources = new LinkedList<Pair<String, String>>();
    }

    public void addStaticPattern(String pattern) {
        this.staticPattern.add(pattern);
    }

    public void addResource(String pattern, String location) {
        this.resources.add((Pair<String, String>)new Pair((Object)pattern, (Object)location));
    }

    public <T extends WebServerProperties> T copy(T subClass) {
        subClass.setVirtualThread(this.virtualThread);
        subClass.setMaxThreads(this.maxThreads);
        subClass.setLocation(this.location);
        subClass.setMaxFileSize(this.maxFileSize);
        subClass.setPort(this.port);
        subClass.setResources(this.resources);
        if (subClass.getPrimarySource() == null) {
            subClass.setPrimarySource(this.primarySource);
        }
        return subClass;
    }

    protected void addDefaultStaticSuffixPattern(String pattern) {
        this.addStaticPattern(pattern + ".js");
        this.addStaticPattern(pattern + ".css");
        this.addStaticPattern(pattern + ".html");
        this.addStaticPattern(pattern + ".png");
        this.addStaticPattern(pattern + ".jpg");
        this.addStaticPattern(pattern + ".jpeg");
        this.addStaticPattern(pattern + ".ico");
        this.addStaticPattern(pattern + ".otf");
        this.addStaticPattern(pattern + ".ttf");
        this.addStaticPattern(pattern + ".woff");
        this.addStaticPattern(pattern + ".woff2");
    }

    public boolean isVirtualThread() {
        return this.virtualThread;
    }

    public Integer getMaxThreads() {
        return this.maxThreads;
    }

    public int getPort() {
        return this.port;
    }

    public String getLocation() {
        return this.location;
    }

    public Long getMaxFileSize() {
        return this.maxFileSize;
    }

    public List<String> getStaticPattern() {
        return this.staticPattern;
    }

    public List<Pair<String, String>> getResources() {
        return this.resources;
    }

    public Class<?> getPrimarySource() {
        return this.primarySource;
    }

    public void setVirtualThread(boolean virtualThread) {
        this.virtualThread = virtualThread;
    }

    public void setMaxThreads(Integer maxThreads) {
        this.maxThreads = maxThreads;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public void setMaxFileSize(Long maxFileSize) {
        this.maxFileSize = maxFileSize;
    }

    public void setStaticPattern(List<String> staticPattern) {
        this.staticPattern = staticPattern;
    }

    public void setResources(List<Pair<String, String>> resources) {
        this.resources = resources;
    }

    public void setPrimarySource(Class<?> primarySource) {
        this.primarySource = primarySource;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WebServerProperties)) {
            return false;
        }
        WebServerProperties other = (WebServerProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isVirtualThread() != other.isVirtualThread()) {
            return false;
        }
        if (this.getPort() != other.getPort()) {
            return false;
        }
        Integer this$maxThreads = this.getMaxThreads();
        Integer other$maxThreads = other.getMaxThreads();
        if (this$maxThreads == null ? other$maxThreads != null : !((Object)this$maxThreads).equals(other$maxThreads)) {
            return false;
        }
        Long this$maxFileSize = this.getMaxFileSize();
        Long other$maxFileSize = other.getMaxFileSize();
        if (this$maxFileSize == null ? other$maxFileSize != null : !((Object)this$maxFileSize).equals(other$maxFileSize)) {
            return false;
        }
        String this$location = this.getLocation();
        String other$location = other.getLocation();
        if (this$location == null ? other$location != null : !this$location.equals(other$location)) {
            return false;
        }
        List<String> this$staticPattern = this.getStaticPattern();
        List<String> other$staticPattern = other.getStaticPattern();
        if (this$staticPattern == null ? other$staticPattern != null : !((Object)this$staticPattern).equals(other$staticPattern)) {
            return false;
        }
        List<Pair<String, String>> this$resources = this.getResources();
        List<Pair<String, String>> other$resources = other.getResources();
        if (this$resources == null ? other$resources != null : !((Object)this$resources).equals(other$resources)) {
            return false;
        }
        Class<?> this$primarySource = this.getPrimarySource();
        Class<?> other$primarySource = other.getPrimarySource();
        return !(this$primarySource == null ? other$primarySource != null : !this$primarySource.equals(other$primarySource));
    }

    protected boolean canEqual(Object other) {
        return other instanceof WebServerProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isVirtualThread() ? 79 : 97);
        result = result * 59 + this.getPort();
        Integer $maxThreads = this.getMaxThreads();
        result = result * 59 + ($maxThreads == null ? 43 : ((Object)$maxThreads).hashCode());
        Long $maxFileSize = this.getMaxFileSize();
        result = result * 59 + ($maxFileSize == null ? 43 : ((Object)$maxFileSize).hashCode());
        String $location = this.getLocation();
        result = result * 59 + ($location == null ? 43 : $location.hashCode());
        List<String> $staticPattern = this.getStaticPattern();
        result = result * 59 + ($staticPattern == null ? 43 : ((Object)$staticPattern).hashCode());
        List<Pair<String, String>> $resources = this.getResources();
        result = result * 59 + ($resources == null ? 43 : ((Object)$resources).hashCode());
        Class<?> $primarySource = this.getPrimarySource();
        result = result * 59 + ($primarySource == null ? 43 : $primarySource.hashCode());
        return result;
    }

    public String toString() {
        return "WebServerProperties(virtualThread=" + this.isVirtualThread() + ", maxThreads=" + this.getMaxThreads() + ", port=" + this.getPort() + ", location=" + this.getLocation() + ", maxFileSize=" + this.getMaxFileSize() + ", staticPattern=" + this.getStaticPattern() + ", resources=" + this.getResources() + ", primarySource=" + this.getPrimarySource() + ")";
    }
}

