/*
 * Decompiled with CFR 0.152.
 */
package com.kfyty.loveqq.framework.web.core.autoconfig;

import com.kfyty.loveqq.framework.core.autoconfig.ApplicationContext;
import com.kfyty.loveqq.framework.core.autoconfig.ContextAfterRefreshed;
import com.kfyty.loveqq.framework.core.autoconfig.annotation.Bean;
import com.kfyty.loveqq.framework.core.autoconfig.annotation.Configuration;
import com.kfyty.loveqq.framework.core.autoconfig.annotation.ConfigurationProperties;
import com.kfyty.loveqq.framework.core.autoconfig.annotation.Import;
import com.kfyty.loveqq.framework.core.autoconfig.beans.BeanDefinition;
import com.kfyty.loveqq.framework.core.autoconfig.condition.annotation.ConditionalOnBean;
import com.kfyty.loveqq.framework.core.autoconfig.condition.annotation.ConditionalOnMissingBean;
import com.kfyty.loveqq.framework.core.autoconfig.condition.annotation.ConditionalOnProperty;
import com.kfyty.loveqq.framework.core.lang.Lazy;
import com.kfyty.loveqq.framework.web.core.WebServer;
import com.kfyty.loveqq.framework.web.core.annotation.Controller;
import com.kfyty.loveqq.framework.web.core.autoconfig.WebServerProperties;
import com.kfyty.loveqq.framework.web.core.cors.CorsConfiguration;
import com.kfyty.loveqq.framework.web.core.cors.CorsFilter;
import com.kfyty.loveqq.framework.web.core.filter.Filter;
import com.kfyty.loveqq.framework.web.core.handler.DefaultRequestMappingMatcher;
import com.kfyty.loveqq.framework.web.core.handler.RequestMappingAnnotationHandler;
import com.kfyty.loveqq.framework.web.core.handler.RequestMappingHandler;
import com.kfyty.loveqq.framework.web.core.handler.RequestMappingMatcher;
import com.kfyty.loveqq.framework.web.core.mapping.MethodMapping;
import java.util.List;
import java.util.Map;

@Configuration
@ConditionalOnBean(value={WebServer.class})
@Import(config={WebServerProperties.class})
public class WebMvcAutoConfig
implements ContextAfterRefreshed {
    @Bean
    public RequestMappingHandler requestMappingHandler() {
        return new RequestMappingAnnotationHandler();
    }

    @Bean
    public RequestMappingMatcher requestMappingMatcher() {
        return new DefaultRequestMappingMatcher();
    }

    @Bean
    @ConfigurationProperties(value="k.mvc.cors")
    @ConditionalOnProperty(prefix="k.mvc.cors", value="allowOrigin", matchIfNonNull=true)
    public CorsConfiguration defaultCorsConfiguration() {
        return new CorsConfiguration();
    }

    @Bean
    @ConditionalOnBean(value={CorsConfiguration.class})
    @ConditionalOnMissingBean(value={CorsFilter.class})
    public Filter defaultCorsFilter(CorsConfiguration configuration) {
        return new CorsFilter(configuration);
    }

    public void onAfterRefreshed(ApplicationContext applicationContext) {
        RequestMappingHandler requestMappingHandler = this.requestMappingHandler();
        RequestMappingMatcher requestMappingMatcher = this.requestMappingMatcher();
        for (Map.Entry entry : applicationContext.getBeanDefinitionWithAnnotation(Controller.class, true).entrySet()) {
            List<MethodMapping> methodMappings = requestMappingHandler.resolveRequestMapping(((BeanDefinition)entry.getValue()).getBeanType(), (Lazy<Object>)new Lazy(() -> applicationContext.getBean((String)entry.getKey())));
            requestMappingMatcher.registryMethodMapping(methodMappings);
        }
        this.startWebServer(applicationContext);
    }

    public void startWebServer(ApplicationContext applicationContext) {
        WebServer server = (WebServer)applicationContext.getBean(WebServer.class);
        if (server != null && !server.isStart()) {
            server.start();
        }
    }
}

