/*
 * Decompiled with CFR 0.152.
 */
package com.kfyty.loveqq.framework.web.core;

import com.kfyty.loveqq.framework.web.core.AbstractDispatcher;
import com.kfyty.loveqq.framework.web.core.http.ServerRequest;
import com.kfyty.loveqq.framework.web.core.http.ServerResponse;
import com.kfyty.loveqq.framework.web.core.interceptor.HandlerInterceptor;
import com.kfyty.loveqq.framework.web.core.interceptor.ReactiveHandlerInterceptor;
import com.kfyty.loveqq.framework.web.core.mapping.MethodMapping;
import java.util.List;
import java.util.stream.Collectors;
import reactor.core.publisher.Mono;

public abstract class AbstractReactiveDispatcher<T extends AbstractReactiveDispatcher<T>>
extends AbstractDispatcher<T> {
    protected Mono<Boolean> applyPreInterceptorAsync(ServerRequest request, ServerResponse response, MethodMapping handler) {
        List<HandlerInterceptor> chains = this.interceptorChains.stream().filter(e -> this.shouldApplyInterceptor(request, response, (HandlerInterceptor)e)).collect(Collectors.toList());
        return this.applyPreInterceptorAsync(chains, request, response, handler, 0);
    }

    protected Mono<Void> applyPostInterceptorAsync(ServerRequest request, ServerResponse response, MethodMapping handler, Object value) {
        List<HandlerInterceptor> chains = this.interceptorChains.stream().filter(e -> this.shouldApplyInterceptor(request, response, (HandlerInterceptor)e)).collect(Collectors.toList());
        return this.applyPostInterceptorAsync(chains, request, response, handler, value, 0);
    }

    protected Mono<Void> applyCompletionInterceptorAsync(ServerRequest request, ServerResponse response, MethodMapping handler, Throwable ex) {
        List<HandlerInterceptor> chains = this.interceptorChains.stream().filter(e -> this.shouldApplyInterceptor(request, response, (HandlerInterceptor)e)).collect(Collectors.toList());
        return this.applyCompletionInterceptorAsync(chains, request, response, handler, ex, 0);
    }

    protected Mono<Boolean> applyPreInterceptorAsync(List<HandlerInterceptor> chains, ServerRequest request, ServerResponse response, MethodMapping handler, int index) {
        if (index >= chains.size() - 1) {
            return chains.isEmpty() ? Mono.just((Object)true) : this.toReactiveInterceptor(chains.get(index)).preHandleAsync(request, response, handler);
        }
        ReactiveHandlerInterceptor interceptor = this.toReactiveInterceptor(chains.get(index));
        return interceptor.preHandleAsync(request, response, handler).filterWhen(e -> this.applyPreInterceptorAsync(chains, request, response, handler, index + 1));
    }

    protected Mono<Void> applyPostInterceptorAsync(List<HandlerInterceptor> chains, ServerRequest request, ServerResponse response, MethodMapping handler, Object value, int index) {
        if (index >= chains.size() - 1) {
            return chains.isEmpty() ? Mono.empty() : this.toReactiveInterceptor(chains.get(index)).postHandleAsync(request, response, handler, value);
        }
        ReactiveHandlerInterceptor interceptor = this.toReactiveInterceptor(chains.get(index));
        return interceptor.postHandleAsync(request, response, handler, value).then(this.applyPostInterceptorAsync(chains, request, response, handler, value, index + 1));
    }

    protected Mono<Void> applyCompletionInterceptorAsync(List<HandlerInterceptor> chains, ServerRequest request, ServerResponse response, MethodMapping handler, Throwable ex, int index) {
        if (index >= chains.size() - 1) {
            return chains.isEmpty() ? Mono.empty() : this.toReactiveInterceptor(chains.get(index)).afterCompletionAsync(request, response, handler, ex);
        }
        ReactiveHandlerInterceptor interceptor = this.toReactiveInterceptor(chains.get(index));
        return interceptor.afterCompletionAsync(request, response, handler, ex).then(this.applyCompletionInterceptorAsync(chains, request, response, handler, ex, index + 1));
    }

    protected ReactiveHandlerInterceptor toReactiveInterceptor(final HandlerInterceptor interceptor) {
        if (interceptor instanceof ReactiveHandlerInterceptor) {
            return (ReactiveHandlerInterceptor)interceptor;
        }
        return new ReactiveHandlerInterceptor(){

            @Override
            public boolean preHandle(ServerRequest request, ServerResponse response, MethodMapping handler) {
                return interceptor.preHandle(request, response, handler);
            }

            @Override
            public void postHandle(ServerRequest request, ServerResponse response, MethodMapping handler, Object retValue) {
                interceptor.postHandle(request, response, handler, retValue);
            }

            @Override
            public void afterCompletion(ServerRequest request, ServerResponse response, MethodMapping handler, Throwable ex) {
                interceptor.afterCompletion(request, response, handler, ex);
            }
        };
    }

    @Override
    public String toString() {
        return "AbstractReactiveDispatcher(super=" + super.toString() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractReactiveDispatcher)) {
            return false;
        }
        AbstractReactiveDispatcher other = (AbstractReactiveDispatcher)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof AbstractReactiveDispatcher;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

