/*
 * Decompiled with CFR 0.152.
 */
package com.kfyty.loveqq.framework.web.core;

import com.kfyty.loveqq.framework.core.autoconfig.aware.BeanFactoryAware;
import com.kfyty.loveqq.framework.core.autoconfig.beans.BeanFactory;
import com.kfyty.loveqq.framework.core.method.MethodParameter;
import com.kfyty.loveqq.framework.core.support.AntPathMatcher;
import com.kfyty.loveqq.framework.core.support.Pair;
import com.kfyty.loveqq.framework.core.support.PatternMatcher;
import com.kfyty.loveqq.framework.web.core.exception.MethodArgumentResolveException;
import com.kfyty.loveqq.framework.web.core.handler.DefaultRequestMappingMatcher;
import com.kfyty.loveqq.framework.web.core.handler.ExceptionHandler;
import com.kfyty.loveqq.framework.web.core.handler.RequestMappingMatcher;
import com.kfyty.loveqq.framework.web.core.http.ServerRequest;
import com.kfyty.loveqq.framework.web.core.http.ServerResponse;
import com.kfyty.loveqq.framework.web.core.interceptor.HandlerInterceptor;
import com.kfyty.loveqq.framework.web.core.mapping.MethodMapping;
import com.kfyty.loveqq.framework.web.core.request.resolver.HandlerMethodArgumentResolver;
import com.kfyty.loveqq.framework.web.core.request.resolver.HandlerMethodReturnValueProcessor;
import com.kfyty.loveqq.framework.web.core.request.support.Model;
import com.kfyty.loveqq.framework.web.core.request.support.ModelViewContainer;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public abstract class AbstractDispatcher<T extends AbstractDispatcher<T>>
implements BeanFactoryAware {
    protected static final String PREFIX_PARAM_NAME = "prefix";
    protected static final String SUFFIX_PARAM_NAME = "suffix";
    protected BeanFactory beanFactory;
    protected String prefix = "";
    protected String suffix = "";
    protected PatternMatcher patternMatcher = new AntPathMatcher();
    protected RequestMappingMatcher requestMappingMatcher = new DefaultRequestMappingMatcher();
    protected List<HandlerInterceptor> interceptorChains = new ArrayList<HandlerInterceptor>(4);
    protected List<HandlerMethodArgumentResolver> argumentResolvers = new ArrayList<HandlerMethodArgumentResolver>(4);
    protected List<HandlerMethodReturnValueProcessor> returnValueProcessors = new ArrayList<HandlerMethodReturnValueProcessor>(4);
    protected List<ExceptionHandler> exceptionHandlers = new ArrayList<ExceptionHandler>(4);

    public boolean isEventStream(String contentType) {
        return contentType != null && contentType.contains("text/event-stream");
    }

    public T addInterceptor(HandlerInterceptor interceptor) {
        this.interceptorChains.add(interceptor);
        return (T)this;
    }

    public T addArgumentResolver(HandlerMethodArgumentResolver argumentResolver) {
        this.argumentResolvers.add(argumentResolver);
        return (T)this;
    }

    public T addReturnProcessor(HandlerMethodReturnValueProcessor returnValueProcessor) {
        this.returnValueProcessors.add(returnValueProcessor);
        return (T)this;
    }

    public T addExceptionHandler(ExceptionHandler exceptionHandler) {
        this.exceptionHandlers.add(exceptionHandler);
        return (T)this;
    }

    protected boolean applyPreInterceptor(ServerRequest request, ServerResponse response, MethodMapping handler) {
        for (HandlerInterceptor interceptor : this.interceptorChains) {
            if (!this.shouldApplyInterceptor(request, response, interceptor) || interceptor.preHandle(request, response, handler)) continue;
            return false;
        }
        return true;
    }

    protected void applyPostInterceptor(ServerRequest request, ServerResponse response, MethodMapping handler, Object value) {
        for (HandlerInterceptor interceptor : this.interceptorChains) {
            if (!this.shouldApplyInterceptor(request, response, interceptor)) continue;
            interceptor.postHandle(request, response, handler, value);
        }
    }

    protected void applyCompletionInterceptor(ServerRequest request, ServerResponse response, MethodMapping handler, Throwable e) {
        for (HandlerInterceptor interceptor : this.interceptorChains) {
            if (!this.shouldApplyInterceptor(request, response, interceptor)) continue;
            interceptor.afterCompletion(request, response, handler, e);
        }
    }

    protected MethodParameter prepareMethodParameter(ServerRequest request, ServerResponse response, MethodMapping methodMapping) {
        int index = 0;
        Parameter[] parameters = methodMapping.getMappingMethod().getParameters();
        Object[] paramValues = new Object[parameters.length];
        for (Parameter parameter : parameters) {
            Object param = this.resolveInternalParameter(parameter, request, response);
            if (param != null) {
                paramValues[index++] = param;
                continue;
            }
            MethodParameter methodParameter = new MethodParameter(methodMapping.getController(), methodMapping.getMappingMethod(), parameter);
            MethodParameter arguments = this.resolveMethodArguments(methodParameter, methodMapping, request);
            if (arguments != null) {
                paramValues[index++] = arguments.getValue();
                continue;
            }
            throw new MethodArgumentResolveException("Can't resolve parameters, there is no suitable parameter resolver available.");
        }
        return methodMapping.buildMethodParameter(paramValues).metadata((Object)methodMapping);
    }

    protected Object resolveInternalParameter(Parameter parameter, ServerRequest request, ServerResponse response) {
        if (ServerRequest.class.isAssignableFrom(parameter.getType())) {
            return request;
        }
        if (ServerResponse.class.isAssignableFrom(parameter.getType())) {
            return response;
        }
        return null;
    }

    protected MethodParameter resolveMethodArguments(MethodParameter methodParameter, MethodMapping methodMapping, ServerRequest request) {
        try {
            for (HandlerMethodArgumentResolver argumentResolver : this.argumentResolvers) {
                if (!argumentResolver.supportsParameter(methodParameter)) continue;
                methodParameter.setValue(argumentResolver.resolveArgument(methodParameter, methodMapping, request));
                return methodParameter;
            }
            return null;
        }
        catch (Exception e) {
            Parameter parameter = methodParameter.getParameter();
            throw new MethodArgumentResolveException(parameter, "method parameter resolve failed: " + parameter.getName(), e);
        }
    }

    protected Pair<MethodParameter, Object> obtainExceptionHandleValue(ServerRequest request, ServerResponse response, MethodMapping mapping, Throwable throwable) throws Throwable {
        for (ExceptionHandler exceptionHandler : this.exceptionHandlers) {
            if (!exceptionHandler.canHandle(mapping, throwable)) continue;
            return exceptionHandler.handle(request, response, mapping, throwable);
        }
        throw throwable;
    }

    protected Object handleReturnValue(Object retValue, MethodParameter returnType, ServerRequest request, ServerResponse response) throws Exception {
        ModelViewContainer container = new ModelViewContainer(this.prefix, this.suffix, request, response);
        if (returnType != null) {
            Arrays.stream(returnType.getMethodArgs()).filter(e -> e != null && Model.class.isAssignableFrom(e.getClass())).findFirst().ifPresent(e -> container.setModel((Model)e));
        }
        for (HandlerMethodReturnValueProcessor returnValueProcessor : this.returnValueProcessors) {
            if (!returnValueProcessor.supportsReturnType(retValue, returnType)) continue;
            return this.applyHandleReturnValueProcessor(retValue, returnType, container, returnValueProcessor);
        }
        throw new IllegalArgumentException("The return value and Content-Type doesn't support yet, please configure a HandlerMethodReturnValueProcessor to handle return value.");
    }

    protected Object applyHandleReturnValueProcessor(Object retValue, MethodParameter returnType, ModelViewContainer container, HandlerMethodReturnValueProcessor returnValueProcessor) throws Exception {
        returnValueProcessor.handleReturnValue(retValue, returnType, container);
        return null;
    }

    protected boolean shouldApplyInterceptor(ServerRequest request, ServerResponse response, HandlerInterceptor interceptor) {
        String requestURI = request.getRequestURI();
        if (interceptor.excludes() != null) {
            for (String exclude : interceptor.excludes()) {
                if (!this.patternMatcher.matches(exclude, requestURI)) continue;
                return false;
            }
        }
        if (interceptor.includes() != null) {
            for (String include : interceptor.includes()) {
                if (!this.patternMatcher.matches(include, requestURI)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public BeanFactory getBeanFactory() {
        return this.beanFactory;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public PatternMatcher getPatternMatcher() {
        return this.patternMatcher;
    }

    public RequestMappingMatcher getRequestMappingMatcher() {
        return this.requestMappingMatcher;
    }

    public List<HandlerInterceptor> getInterceptorChains() {
        return this.interceptorChains;
    }

    public List<HandlerMethodArgumentResolver> getArgumentResolvers() {
        return this.argumentResolvers;
    }

    public List<HandlerMethodReturnValueProcessor> getReturnValueProcessors() {
        return this.returnValueProcessors;
    }

    public List<ExceptionHandler> getExceptionHandlers() {
        return this.exceptionHandlers;
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    public void setPatternMatcher(PatternMatcher patternMatcher) {
        this.patternMatcher = patternMatcher;
    }

    public void setRequestMappingMatcher(RequestMappingMatcher requestMappingMatcher) {
        this.requestMappingMatcher = requestMappingMatcher;
    }

    public void setInterceptorChains(List<HandlerInterceptor> interceptorChains) {
        this.interceptorChains = interceptorChains;
    }

    public void setArgumentResolvers(List<HandlerMethodArgumentResolver> argumentResolvers) {
        this.argumentResolvers = argumentResolvers;
    }

    public void setReturnValueProcessors(List<HandlerMethodReturnValueProcessor> returnValueProcessors) {
        this.returnValueProcessors = returnValueProcessors;
    }

    public void setExceptionHandlers(List<ExceptionHandler> exceptionHandlers) {
        this.exceptionHandlers = exceptionHandlers;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractDispatcher)) {
            return false;
        }
        AbstractDispatcher other = (AbstractDispatcher)o;
        if (!other.canEqual(this)) {
            return false;
        }
        BeanFactory this$beanFactory = this.getBeanFactory();
        BeanFactory other$beanFactory = other.getBeanFactory();
        if (this$beanFactory == null ? other$beanFactory != null : !this$beanFactory.equals(other$beanFactory)) {
            return false;
        }
        String this$prefix = this.getPrefix();
        String other$prefix = other.getPrefix();
        if (this$prefix == null ? other$prefix != null : !this$prefix.equals(other$prefix)) {
            return false;
        }
        String this$suffix = this.getSuffix();
        String other$suffix = other.getSuffix();
        if (this$suffix == null ? other$suffix != null : !this$suffix.equals(other$suffix)) {
            return false;
        }
        PatternMatcher this$patternMatcher = this.getPatternMatcher();
        PatternMatcher other$patternMatcher = other.getPatternMatcher();
        if (this$patternMatcher == null ? other$patternMatcher != null : !this$patternMatcher.equals(other$patternMatcher)) {
            return false;
        }
        RequestMappingMatcher this$requestMappingMatcher = this.getRequestMappingMatcher();
        RequestMappingMatcher other$requestMappingMatcher = other.getRequestMappingMatcher();
        if (this$requestMappingMatcher == null ? other$requestMappingMatcher != null : !this$requestMappingMatcher.equals(other$requestMappingMatcher)) {
            return false;
        }
        List<HandlerInterceptor> this$interceptorChains = this.getInterceptorChains();
        List<HandlerInterceptor> other$interceptorChains = other.getInterceptorChains();
        if (this$interceptorChains == null ? other$interceptorChains != null : !((Object)this$interceptorChains).equals(other$interceptorChains)) {
            return false;
        }
        List<HandlerMethodArgumentResolver> this$argumentResolvers = this.getArgumentResolvers();
        List<HandlerMethodArgumentResolver> other$argumentResolvers = other.getArgumentResolvers();
        if (this$argumentResolvers == null ? other$argumentResolvers != null : !((Object)this$argumentResolvers).equals(other$argumentResolvers)) {
            return false;
        }
        List<HandlerMethodReturnValueProcessor> this$returnValueProcessors = this.getReturnValueProcessors();
        List<HandlerMethodReturnValueProcessor> other$returnValueProcessors = other.getReturnValueProcessors();
        if (this$returnValueProcessors == null ? other$returnValueProcessors != null : !((Object)this$returnValueProcessors).equals(other$returnValueProcessors)) {
            return false;
        }
        List<ExceptionHandler> this$exceptionHandlers = this.getExceptionHandlers();
        List<ExceptionHandler> other$exceptionHandlers = other.getExceptionHandlers();
        return !(this$exceptionHandlers == null ? other$exceptionHandlers != null : !((Object)this$exceptionHandlers).equals(other$exceptionHandlers));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AbstractDispatcher;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        BeanFactory $beanFactory = this.getBeanFactory();
        result = result * 59 + ($beanFactory == null ? 43 : $beanFactory.hashCode());
        String $prefix = this.getPrefix();
        result = result * 59 + ($prefix == null ? 43 : $prefix.hashCode());
        String $suffix = this.getSuffix();
        result = result * 59 + ($suffix == null ? 43 : $suffix.hashCode());
        PatternMatcher $patternMatcher = this.getPatternMatcher();
        result = result * 59 + ($patternMatcher == null ? 43 : $patternMatcher.hashCode());
        RequestMappingMatcher $requestMappingMatcher = this.getRequestMappingMatcher();
        result = result * 59 + ($requestMappingMatcher == null ? 43 : $requestMappingMatcher.hashCode());
        List<HandlerInterceptor> $interceptorChains = this.getInterceptorChains();
        result = result * 59 + ($interceptorChains == null ? 43 : ((Object)$interceptorChains).hashCode());
        List<HandlerMethodArgumentResolver> $argumentResolvers = this.getArgumentResolvers();
        result = result * 59 + ($argumentResolvers == null ? 43 : ((Object)$argumentResolvers).hashCode());
        List<HandlerMethodReturnValueProcessor> $returnValueProcessors = this.getReturnValueProcessors();
        result = result * 59 + ($returnValueProcessors == null ? 43 : ((Object)$returnValueProcessors).hashCode());
        List<ExceptionHandler> $exceptionHandlers = this.getExceptionHandlers();
        result = result * 59 + ($exceptionHandlers == null ? 43 : ((Object)$exceptionHandlers).hashCode());
        return result;
    }

    public String toString() {
        return "AbstractDispatcher(beanFactory=" + this.getBeanFactory() + ", prefix=" + this.getPrefix() + ", suffix=" + this.getSuffix() + ", patternMatcher=" + this.getPatternMatcher() + ", requestMappingMatcher=" + this.getRequestMappingMatcher() + ", interceptorChains=" + this.getInterceptorChains() + ", argumentResolvers=" + this.getArgumentResolvers() + ", returnValueProcessors=" + this.getReturnValueProcessors() + ", exceptionHandlers=" + this.getExceptionHandlers() + ")";
    }
}

